@extends('backend.layouts.app')
@section('title','Book Create')
@section('book-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Book Create")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('book.index')}}">Book</a></li>
                                    <li class="breadcrumb-item active">{{__("Create")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="book-form" action="{{ route('book.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{old('title')}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="title_mm" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{old('title_mm')}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_keyword" class="form-label">{{__("Meta Keyword")}}</label>
                                                <input class="form-control @error('meta_keyword') is-invalid @enderror" type="text" name="meta_keyword"  value="{{old('meta_keyword')}}"  >
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->

                                        {{--  <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_description" class="form-label">{{__("Meta Description")}}</label>
                                                <textarea class="form-control @error('meta_description') is-invalid @enderror"  name="meta_description" >{{old('meta_description')}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>  --}}
                                        <!-- end col -->

                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input" type="checkbox" value="active"  name="status" checked id="is_active" onchange="getValue()">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                <img id="frame" width="50%" src="" class="img-fluid" />
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="File" class="form-label">{{__("Attached File(PDF)")}}<span class="text-danger">*</span></label>
                                                <input required class="form-control @error('file_url') is-invalid @enderror" type="file" name="file_url" >
                                                @error('file_url')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->


                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
<script>

    //if you want get value
  function getValue()
  {
   var value=$('#is_active').prop('checked')==true?'active':'inactive';
   var append=`<input type="hidden" name="status" value=`+value+`>`;
   $('.book-form').append(append);
  }
</script>
@endsection
