@extends('backend.layouts.app')
@section('title','Book Edit')
@section('book-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Book Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('book.index')}}">Book</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="book-form" action="{{ route('book.update', \Crypt::encrypt($book->id)) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{$book->title}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="title_mm" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{$book->title_mm}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_keyword" class="form-label">{{__("Meta Keyword")}}</label>
                                                <input class="form-control @error('meta_keyword') is-invalid @enderror" type="text" name="meta_keyword" value="{{$book->meta_keyword}}" >
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        {{--  <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_description" class="form-label">{{__("Meta Description")}}</label>
                                                <textarea class="form-control @error('meta_description') is-invalid @enderror" name="meta_description" >{{$book->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>  --}}
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">

                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input" type="checkbox" value="{{$book->status}}"  name="status" {{$book->status=='active'?'checked':''}} id="is_active" onchange="getValue()">
                                                </label>

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12" id="file_frame">
                                            <div class="row justify-content-center">
                                                @if(isset($book->file_url))
                                                    @php
                                                        $file=$book->file_url;
                                                        $extension = pathinfo($file, PATHINFO_EXTENSION);
                                                    @endphp
                                                    <div class="border p-2 m-1 col-4 text-center">
                                                        @if(Storage::exists('public/'.$file))
                                                        <a class="btn preview_modal" href="" data-bs-toggle="modal" data-bs-target=".fileModal" data-bs-file="{{$file}}" data-bs-extension="{{$extension}}" >
                                                            @if($extension=='pdf')
                                                                <img style="width:70px;height:70px;" src="{{ asset('backend/images/no-image.svg') }}" alt="" class="img-thumbnail">
                                                            @else
                                                                <img style="width:70px;height:70px;" src="{{ asset('/storage/'.$file) }}"  class="img-thumbnail">
                                                            @endif
                                                        </a>
                                                        @endif
                                                    </div>

                                                @endif
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="file_url" class="form-label">{{__("Attached Files(Images/PDFs)")}}</label>
                                                <input class="form-control @error('file_url') is-invalid @enderror" type="file" name="file_url" id="formFile" multiple>
                                                @error('file_url')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->


                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
                @include('backend.common.modal')
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
@include('backend.common.modaljs')
<script>

    //if you want get value
    getValue()
    function getValue()
    {
        var value=$('#is_active').prop('checked')==true?'active':'inactive';
    var append=`<input type="hidden" name="status" value=`+value+`>`;
    $('.book-form').append(append);
    }
</script>
@endsection
