@extends('backend.layouts.app')
@section('title', 'Book List')
@section('book-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Book List') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Book') }}</a></li>
                                    <li class="breadcrumb-item active">{{ __('List') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <form action="" method="get" class="form myform">
                                            @csrf
                                            <input type="hidden" name="order_by" value="books.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="search"
                                                            placeholder="Search"
                                                            value="{{ $input['search'] ?? old('search') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <select class="form-control" name="status">
                                                            <option value="">--Select Status--</option>
                                                            <option value='active'
                                                                {{ isset($input['status']) && $input['status'] == 'active' ? 'selected' : '' }}>
                                                                {{ __('Active') }}</option>
                                                            <option value='inactive'
                                                                {{ isset($input['status']) && $input['status'] == 'inactive' ? 'selected' : '' }}>
                                                                {{ __('Inactive') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end col -->
                                    @if (auth()->user()->hasPermissionTo('book_create'))
                                        <div class="col-md-4">
                                            <div class="float-md-end">
                                                <form action="{{ route('book.create') }}" class="form" method="get">

                                                    <div class="mb-4">
                                                        <button type="submit"
                                                            class="btn btn-success waves-effect waves-light"> <i
                                                                class="mdi mdi-plus me-2"></i>{{ __('Add Book') }}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    @endif
                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0" id="myTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('No') }}</th>
                                                <th class="order-by order-by-arrow books-title">
                                                    <span class='books.title'>
                                                        @if (session()->get('locale') == 'en')
                                                            {{ __('Title(English)') }}
                                                        @else
                                                            {{ __('Title(Myanmar)') }}
                                                        @endif
                                                    </span>
                                                </th>
                                                {{-- <th class="order-by order-by-arrow books-meta_keyword">
                                                    <span class='books.meta_keyword'>
                                                        {{__("Meta Keyword")}}
                                                    </span>
                                                </th> --}}
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Created By') }}</th>
                                                <th>{{ __('Updated By') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($books as $key => $book)
                                                <tr>
                                                    <th scope="row">{{ $books->firstItem() + $key }}</th>
                                                    {{-- <td>
                                                    @if (isset($book->profile_image) && Storage::disk('public')->exists($book->profile_image))
                                                        <img class="avatar-xs rounded-circle" src="{{ asset('storage/'.$book->profile_image) }}" alt="">
                                                    @else
                                                        <img class="avatar-xs rounded-circle" src="{{ asset('backend/images/admin_avatar.png') }}" alt="">
                                                    @endif
                                                    </td> --}}
                                                    <td>
                                                        @if (session()->get('locale') == 'en')
                                                            {{ $book->title }}
                                                        @else
                                                            {{ $book->title_mm }}
                                                        @endif
                                                    </td>

                                                    {{-- <td>
                                                    {{$book->meta_keyword}}
                                                </td> --}}

                                                    <td>
                                                        <input class="toggle-trigger" type="checkbox"
                                                            {{ $book->status == 'active' ? 'checked' : '' }}
                                                            data-toggle="toggle" data-onstyle="success"
                                                            data-offstyle="danger"
                                                            data-id="{{ \Crypt::encrypt($book->id) }}"
                                                            value="{{ $book->status }}" name="status"
                                                            @if (!auth()->user()->hasPermissionTo('book_status')) disabled @endif>
                                                    </td>
                                                    <td>{{ $book->CreatedBy->name }}</td>
                                                    <td>{{ $book->UpdatedBy->name ?? '' }}</td>
                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('book_list'))
                                                            <a href="{{ route('book.show', \Crypt::encrypt($book->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('book_edit'))
                                                            <a href="{{ route('book.edit', \Crypt::encrypt($book->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="Edit"><i
                                                                    class="mdi mdi-pencil font-size-18"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('book_delete'))
                                                            <a href="javascript:void(0);" class="text-danger delete-record"
                                                                data-bs-placement="top" title="Delete"
                                                                data-id="{{ \Crypt::encrypt($book->id) }}"
                                                                data-action="{{ route('book.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $books->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')
    @include('backend.common.changestatus', ['url' => 'change-book-status'])

@endsection
