@extends('backend.layouts.app')
@section('title','Book Detail')
@section('book-active','mm-active active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('fail'))
                    <div class="alert alert-danger">
                        {{ session()->get('fail') }}
                    </div>
                @endif
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Book Detail")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('book.index')}}">{{__("Book")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Detail")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="container py-5" >
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Title(English)")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">
                                                        {{$book->title}}
                                                </p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Title(Myanmar)")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$book->title_mm}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Meta Keyword")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$book->meta_keyword}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        {{--  <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Meta Description")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$book->meta_description}}</p>
                                            </div>
                                        </div>  --}}
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Is Active?")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{ucfirst($book->status)}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Created By")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{$book->CreatedBy->name}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Updated By")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{$book->UpdatedBy->name??''}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                    </div>
                                    <!-- end card-body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <!-- end col -->
                            <div class="col-lg-4">
                                <div class="card mb-4">
                                    <div class="card-body">

                                        <div class="row">
                                            <div class="col-sm-12">
                                                <strong class="mb-0">{{__("Attached File")}}</strong>
                                            </div>
                                            <div class="col-sm-12">
                                                <div class="row justify-content-center">
                                                    @if(isset($book->file_url))
                                                        @php
                                                            $file=$book->file_url;
                                                            $extension = pathinfo($file, PATHINFO_EXTENSION);
                                                        @endphp
                                                        <div class="border m-1 text-center">
                                                            @if(Storage::exists('public/'.$file))
                                                            <a class="btn preview_modal" href="" data-bs-toggle="modal" data-bs-target=".fileModal" data-bs-file="{{$file}}" data-bs-extension="{{$extension}}" >
                                                                @if( $extension=='pdf')
                                                                    <img style="width:100%;height:100%;" src="{{ asset('backend/images/no-image.svg') }}" alt="" class="img-thumbnail">
                                                                @else
                                                                    <img style="width:100%;height:100%;" src="{{ asset('/storage/'.$file) }}"  class="img-thumbnail">
                                                                @endif
                                                            </a>
                                                            @endif
                                                        </div>

                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>

                                    </div>
                                    <!-- end card-body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <!-- end col -->
                        </div>
                        <!-- end row -->
                        @include('backend.common.modal')
                    </div>
                    <!-- end container -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
@include('backend.common.modaljs')
@endsection
