<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--Csrf Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title')</title>
    <!-- App favicon -->
    @if (isset($favicon->value) && Storage::disk('public')->exists($favicon->value))
        <link rel="icon" type="image/png" sizes="96x96" href="{{ asset('storage/' . $favicon->value) }}">
    @else
        <link rel="icon" type="image/png" sizes="96x96" href="{{ asset(Setting::FAVICON_ICON) }}">
    @endif

    <!-- Bootstrap Css -->
    <link href="{{ asset('backend/css/bootstrap.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Bootstrap button toggle Css -->
    <link href="{{ asset('backend/css/bootstrap-toggle.min.css') }}" id="bootstrap-style" rel="stylesheet"
        type="text/css" />
    <!-- Icons Css -->
    <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- App Css-->
    <link href="{{ asset('backend/css/app.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />

    <!-- Custom Css-->
    {{-- <link href="{{asset('backend/css/summernote.min.css')}}"  rel="stylesheet" type="text/css" /> --}}

    <!-- Custom Css-->
    <link href="{{ asset('backend/css/custom.css') }}" rel="stylesheet" type="text/css" />


    <!-- Jquery -->
    <script src="{{ asset('backend/libs/jquery/jquery-3.6.4.min.js') }}"></script>
    <!-- Sweet alert -->
    <script src="{{ asset('backend/js/pages/sweetalert2.min.js') }}"></script>

    <!-- Show Password -->
    <link rel="stylesheet" href="{{ asset('backend/css/show-password-toggle.css') }}">
    @yield('custom_css')
    <style>
        @font-face {
            font-family: 'Pyidaungsu';
            src: "{{ asset('backend/fonts/Pyidaungsu.ttf') }} format('truetype')";
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: Pyidaungsu !important;
        }
    </style>
</head>

<body data-topbar="dark">

    <!-- <body data-layout="horizontal" data-topbar="dark"> -->

    <!-- Begin page -->
    <div id="layout-wrapper">

        @include('backend.layouts.header')

        @include('backend.layouts.sidebar')

        @yield('content')

        @include('backend.layouts.footer')

    </div>
    <!-- END layout-wrapper -->


    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- JAVASCRIPT -->

    <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/libs/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
    <!-- Bootstrap toggle button -->
    <script src="{{ asset('backend/js/pages/bootstrap-toggle.min.js') }}"></script>
    <!-- summernote -->
    {{-- <script src="{{asset('backend/js/pages/summernote.min.js')}}"></script> --}}


    <!--tinymce js-->
    <script src="{{ asset('backend/libs/tinymce/tinymce.min.js') }}"></script><!-- for text editor-->
    <!-- init js -->
    <script src="{{ asset('backend/js/pages/form-editor.init.js') }}"></script><!-- for text editor-->

    <!-- App js -->
    <script src="{{ asset('backend/js/app.js') }}"></script>
    <script>
        $(document).ready(function() {
            let token = document.head.querySelector('meta[name="csrf-token"]');
            if (token) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': token.content
                    }
                });
            }

        });
    </script>
    @include('backend.common.delete')
    @include('common.savetimezone')

    @yield('custom_js')
    @yield('modals')
</body>

</html>
