@extends('backend.layouts.app')
@section('title','Menu Create')
@section('menu-active','active')
@section('custom_css')


<link href="{{asset('backend/css/jquery.nestable.min.css')}}" rel="stylesheet">
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                @include('backend.common.message')
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-flex align-items-center justify-content-between">
                            <h4 class="mb-0">Manage Menu</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('menu')}}">Menu</a></li>

                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <div class="row">
                    <div class="col-6">
                        <div class="dd">
                            <ol class="dd-list ">
                                @foreach($menus as $menu)
                                    <li class="dd-item " data-id="{{\Crypt::encrypt($menu->id)}}" >
                                        <div class="d-flex">
                                            <div class=" m-auto" style="width:70%">
                                                <div class="dd-handle" @if($menu->status=='inactive') style="font-weight:100" @endif>
                                                    {{session()->get('locale')=='en'?$menu->label:$menu->label_mm}}
                                                </div>
                                            </div>
                                            <div class=" m-auto">
                                                <button class="btn btn-outline-primary edit_menu" data-id="{{\Crypt::encrypt($menu->id)}}">
                                                    @if(auth()->user()->hasPermissionTo('menu_edit'))
                                                    {{__("Edit")}}
                                                    @else
                                                    {{__("Show")}}
                                                    @endif
                                                </button>
                                            </div>
                                        </div>

                                        @php
                                            $childs=MenuItemModel::where('parent',$menu->id)->get();
                                        @endphp
                                        @if($childs)
                                            @include('backend.menu.submenu', ['submenus' => $menu->child])
                                        @endif
                                    </li>
                                @endforeach
                            </ol>
                            @if(auth()->user()->hasPermissionTo('menu_edit'))
                            <div class="d-flex mt-3 justify-content-center">
                                <form action="{{route('menu-drag')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="menu_array" class="menu_array">
                                    <input class="btn btn-primary" type="submit" name="submit" value="{{__('Save Menu')}}">
                                </form>
                            </div>
                            @endif
                        </div>
                    </div>
                    <!-- end col -->
                    <div class="col-6 d-none edit_form">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{route('update-menuitem')}}" method="post" class="edit_form">
                                    @csrf
                                    <input type="hidden" class="menu_id" name="id">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="label" class="form-label">{{__("Label(English)")}} </label>
                                                <input required type="text" class="form-control label" name="label" placeholder="Label(English)" value="" >
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="label" class="form-label">{{__("Label(Myanmar)")}} </label>
                                                <input required type="text" class="form-control label_mm" name="label_mm" placeholder="Label(Myanmar)" value="" >
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input status" type="checkbox" value="active"  name="status" id="is_active" onchange="getValue()">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end row -->
                                    @if(auth()->user()->hasPermissionTo('menu_edit'))
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Update")}}</button>
                                    </div>
                                    @endif
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
<script src="{{asset('backend/js/pages/jquery.nestable.min.js')}}"></script>
<script>
$('.dd').nestable();
 $('.dd').on('change',function(){
    // console.log(JSON.stringify($('.dd').nestable('toArray')));
    var menu_array=JSON.stringify($('.dd').nestable('toArray'));
    $('.menu_array').val(menu_array);
 });

//  edit menu
$('.edit_menu').on('click',function(){
    $('.edit_form').removeClass('d-none');
    var id=$(this).attr('data-id');
    var url="{{route('get-menuitem')}}";
    $.ajax({
            type:'GET',
            url:url,
            data:{
                id:id,
            },
            success:function(response) {
                $('.menu_id').val(id);
                $('.label').val(response.data.label);
                $('.label_mm').val(response.data.label_mm);
                if(response.data.status=='active')
                {
                    $('.status').prop('checked', true);
                }else{
                    $('.status').prop('checked', false);
                }
            }
         });

});
//if you want get value
function getValue()
{
    var value=$('#is_active').prop('checked')==true?'active':'inactive';
    var append=`<input type="hidden" name="status" value=`+value+`>`;
    $('.edit_form').append(append);
}

</script>
@endsection
