@extends('backend.layouts.app')
@section('title','ContactUs Edit')
@section('contactus-active','mm-active active')
@section('custom_css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                {{--  @include('backend.common.message')  --}}
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">ContactUs Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('contactus.show','contactus')}}">ContactUs</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="contactus-form" action="{{ route('contactus.update', 'contactus') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="mb-3 text-center">
                                                        @if($data['logo1']->logo_url != null && Storage::disk('public')->has($data['logo1']->logo_url))
                                                            <img id="logo1frame" height="100px" src="{{ asset('storage/'.$data['logo1']->logo_url) }}"  class="" />
                                                            <button type="button" class="btn btn-danger btn-sm position-absolute top-0 end-0" onclick="deleteImage('phone')"><i class="ri-delete-bin-line"></i></button>
                                                        @else
                                                            <img id="logo1frame" height="100px" src="{{ asset('frontend/assets/image/contact-us/icon/phone.png') }}" class="" />
                                                        @endif

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                {{-- <div class="col-12">
                                                    <select
                                                        name="icon"
                                                        id="icon"
                                                        class="icons_select2 form-control form-data"
                                                        data-size="auto"
                                                        title="@lang('back.select-a-value')"
                                                    >
                                                        @foreach($data['icons'] as $icon)
                                                            <option data-icon="{{ $icon['icon'] }}" value="{{ $icon['icon'] }}">
                                                                {{ Str::of($icon['name'])->headline() }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div> --}}
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{ucfirst($data['logo1']->type)}}{{__(" Logo Image(100 x 100)")}}</label>
                                                        <input class="form-control @error('logo1_url') is-invalid @enderror" type="file" name="logo1_url" onchange="previewLogo1()">
                                                        @error('logo1_url')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Phone Title(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title.0') is-invalid @enderror" type="text" name="title[]" value="{{$data['logo1']->title}}" placeholder="Enter Title(English)">
                                                        @error('title.0')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Phone Title(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title_mm.0') is-invalid @enderror" type="text" name="title_mm[]" value="{{$data['logo1']->title_mm}}"  placeholder="Enter Title(Myanmar)">
                                                        @error('title_mm.0')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Phone Description(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc.0') is-invalid @enderror" type="text" name="desc[]" value="{{$data['logo1']->desc}}"  placeholder="Enter Description(English)">
                                                        @error('desc.0')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Phone Description(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc_mm.0') is-invalid @enderror" type="text" name="desc_mm[]" value="{{$data['logo1']->desc_mm}}"  placeholder="Enter Description(Myanmar)">
                                                        @error('desc_mm.0')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                            </div>
                                            <!-- end row -->
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="mb-3 text-center">
                                                        @if($data['logo2']->logo_url != null && Storage::disk('public')->has($data['logo2']->logo_url))
                                                            <img id="logo2frame" height="100px" src="{{ asset('storage/'.$data['logo2']->logo_url) }}"  class="" />
                                                            <button type="button" class="btn btn-danger btn-sm position-absolute top-0 end-0" onclick="deleteImage('email')"><i class="ri-delete-bin-line"></i></button>
                                                        @else
                                                            <img id="logo2frame" height="100px" src="{{ asset('frontend/assets/image/contact-us/icon/email.png') }}"class="" />
                                                        @endif

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{ucfirst($data['logo2']->type)}}{{__(" Logo Image(100 x 100)")}}</label>
                                                        <input class="form-control @error('logo2_url') is-invalid @enderror" type="file" name="logo2_url" onchange="previewLogo2()">
                                                        @error('logo2_url')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Email Title(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title.1') is-invalid @enderror" type="text" name="title[]" value="{{$data['logo2']->title}}"  placeholder="Enter Title(English)">
                                                        @error('title.1')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Email Title(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title_mm.1') is-invalid @enderror" type="text" name="title_mm[]" value="{{$data['logo2']->title_mm}}" placeholder="Enter Title(Myanmar)">
                                                        @error('title_mm.1')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Email Description(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc.1') is-invalid @enderror" type="text" name="desc[]" value="{{$data['logo2']->desc}}" placeholder="Enter Description(English)">
                                                        @error('desc.1')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Email Description(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc_mm.1') is-invalid @enderror" type="text" name="desc_mm[]" value="{{$data['logo2']->desc_mm}}" placeholder="Enter Description(Myanmar)">
                                                        @error('desc_mm.1')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                            </div>
                                            <!-- end row -->
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-body ">
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="mb-3 text-center">
                                                        @if($data['logo3']->logo_url != null && Storage::disk('public')->has($data['logo3']->logo_url))
                                                            <img id="logo3frame" height="100px" src="{{ asset('storage/'.$data['logo3']->logo_url) }}"  class="" />
                                                            <button type="button" class="btn btn-danger btn-sm position-absolute top-0 end-0" onclick="deleteImage('address')"><i class="ri-delete-bin-line"></i></button>
                                                        @else
                                                            <img id="logo3frame" height="100px" src="{{ asset('frontend/assets/image/contact-us/icon/address.png') }}" class="" />
                                                        @endif

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{ucfirst($data['logo3']->type)}}{{__(" Logo Image(100 x 100)")}}</label>
                                                        <input class="form-control @error('logo3_url') is-invalid @enderror" type="file" name="logo3_url" onchange="previewLogo3()">
                                                        @error('logo3_url')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Address Title(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title.2') is-invalid @enderror" type="text" name="title[]" value="{{$data['logo3']->title}}" placeholder="Enter Title(English)">
                                                        @error('title.2')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Address Title(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('title_mm.2') is-invalid @enderror" type="text" name="title_mm[]" value="{{$data['logo3']->title_mm}}"  placeholder="Enter Title(Myanmar)">
                                                        @error('title_mm.2')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Address Description(English)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc.2') is-invalid @enderror" type="text" name="desc[]" value="{{$data['logo3']->desc}}"  placeholder="Enter Description(English)">
                                                        @error('desc.2')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Address Description(Myanmar)")}}<span class="text-danger">*</span></label>
                                                        <input class="form-control @error('desc_mm.2') is-invalid @enderror" type="text" name="desc_mm[]" value="{{$data['logo3']->desc_mm}}"  placeholder="Enter Description(Myanmar)">
                                                        @error('desc_mm.2')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->
                                            </div>
                                            <!-- end row -->
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end col -->
                        <div class="col-lg-12 col-md-12 center-box">
                            <div class="row">
                                <div class="col-md-2 col-xs-12"></div>
                                <div class="col-md-8 col-xs-12">
                                    <div class="card single_contactus">
                                        <div class="card-body">
                                            <div>
                                                <div class="fw-bold">{{__('Map Frame')}}<span class="text-danger">*</span></div>
                                                <div class="text-muted">
                                                    <textarea class="form-control @error('map_frame') is-invalid @enderror" name="map_frame" >{{$data['map']->map_frame}}</textarea>
                                                    @error('map_frame')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                {{--  <form action="{{route('contactus.edit','contactus')}}" method="get">
                                                    @csrf  --}}
                                                    <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                                {{--  </form>  --}}

                                            </div>
                                        </div>
                                        <!-- card-body -->

                                    </div>
                                    <!-- end card -->
                                </div>
                                <div class="col-md-2 col-xs-12"></div>
                            </div>
                            <!-- end row -->

                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
function previewLogo1()
{
    logo1frame.src = URL.createObjectURL(event.target.files[0]);
}
function previewLogo2()
{
    logo2frame.src = URL.createObjectURL(event.target.files[0]);
}
function previewLogo3()
{
    logo3frame.src = URL.createObjectURL(event.target.files[0]);
}
function deleteImage(logoName)
{
    var url="{{route('contactus-delete-image')}}";
    console.log(url);
    $('.contactus-form').attr('action',url);
    $('input[name="_method"]').val('POST');
    $('.contactus-form').append(`<input name="delete_image_type" value="`+logoName+`" />`);
    $('.contactus-form').submit();
}

// let iformat = (icon) => $('<span><i class="fa ' + $(icon.element).data('icon') + '"></i> ' + icon.text + '</span>');

// $('.icons_select2').select2({
//     width: "100%",
//     templateSelection: iformat,
//     templateResult: iformat,
//     allowHtml: true
// });

</script>
@endsection
