@extends('backend.layouts.app')
@section('title','ContactUs Detail')
@section('contactus-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("ContactUs Detail")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{__("ContactUs")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Detail")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div id="main-content" class="blog-page">
                        <div class="container">
                            <div class="row clearfix">
                                <div class="col-lg-12 col-md-12">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-12 p-5" style="height:100%;">
                                                            @if($data['logo1']->logo_url != null && Storage::disk('public')->has($data['logo1']->logo_url))
                                                                <img class="d-block  m-auto" height="100px"  src="{{ asset('storage/'.$data['logo1']->logo_url) }}" alt="Phone Logo Image">
                                                            @else
                                                                <img class="d-block  m-auto" height="100px" src="{{ asset(ContactUs::PHONE_IMAGE) }}" alt="Phone Logo Image">
                                                            @endif
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo1']->title??''}} </div>
                                                                <div class="col-6">: {{$data['logo1']->desc??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo1']->title_mm??''}}</div>
                                                                <div class="col-6">: {{$data['logo1']->desc_mm??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Created By")}}</div>
                                                                <div class="col-6">: {{$data['logo1']->CreatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Updated By")}}</div>
                                                                <div class="col-6">: {{$data['logo1']->UpdatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                    </div>
                                                    <!-- end row -->
                                                </div>
                                                <!-- end card-body -->
                                            </div>
                                            <!-- end card -->
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-12 p-5" style="height:100%;">
                                                            @if($data['logo2']->logo_url != null && Storage::disk('public')->has($data['logo2']->logo_url))
                                                                <img class="d-block m-auto" height="100px" src="{{ asset('storage/'.$data['logo2']->logo_url) }}" alt="Phone Logo Image">
                                                            @else
                                                                <img class="d-block m-auto" height="100px" src="{{ asset(ContactUs::EMAIL_IMAGE) }}" alt="Phone Logo Image">
                                                            @endif
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo2']->title??''}} </div>
                                                                <div class="col-6">: {{$data['logo2']->desc??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo2']->title_mm??''}}</div>
                                                                <div class="col-6">: {{$data['logo2']->desc_mm??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Created By")}}</div>
                                                                <div class="col-6">: {{$data['logo2']->CreatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Updated By")}}</div>
                                                                <div class="col-6">: {{$data['logo2']->UpdatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                    </div>
                                                    <!-- end row -->
                                                </div>
                                                <!-- end card-body -->
                                            </div>
                                            <!-- end card -->
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-12 p-5" style="height:100%;">
                                                            @if($data['logo3']->logo_url != null && Storage::disk('public')->has($data['logo3']->logo_url))
                                                                <img class="d-block m-auto" height="100px" src="{{ asset('storage/'.$data['logo3']->logo_url) }}" alt="Phone Logo Image">
                                                            @else
                                                                <img class="d-block m-auto" height="100px" src="{{ asset(ContactUs::ADDRESS_IMAGE) }}" alt="Phone Logo Image">
                                                            @endif
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo3']->title??''}} </div>
                                                                <div class="col-6">: {{$data['logo3']->desc??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{$data['logo3']->title_mm??''}}</div>
                                                                <div class="col-6">: {{$data['logo3']->desc_mm??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Created By")}}</div>
                                                                <div class="col-6">: {{$data['logo3']->CreatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-6">{{__("Updated By")}}</div>
                                                                <div class="col-6">: {{$data['logo3']->UpdatedBy->name??''}}</div>
                                                            </div>
                                                        </div>
                                                        <!-- end col -->
                                                    </div>
                                                    <!-- end row -->
                                                </div>
                                                <!-- end card-body -->
                                            </div>
                                            <!-- end card -->
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                </div>
                                <!-- end col -->
                                <div class="col-lg-12 col-md-12 center-box">
                                    <div class="row">
                                        <div class="col-md-2 col-xs-12"></div>
                                        <div class="col-md-8 col-xs-12">
                                            <div class="card single_contactus">
                                                <div class="card-body">

                                                    <ul class="list-group list-group-light">
                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                            <div>
                                                              <div class="fw-bold">{{__('Menu')}}</div>
                                                                <div class="text-muted">
                                                                    @if(isset($data['logo1']->menuItem->label))
                                                                    {{session()->get('locale')=='en'?$data['logo1']->menuItem->label:$data['logo1']->menuItem->label_mm}}
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                            <div class="overflow-hidden">
                                                              <div class="fw-bold">{{__('Map URL')}}</div>
                                                              <div class="text-muted">{{$data['map']->map_frame}}</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                            <div>
                                                              <div class="fw-bold">{{__('Created By')}}</div>
                                                              <div class="text-muted">{{$data['map']->CreatedBy->name??''}}</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                            <div>
                                                              <div class="fw-bold">{{__('Updated By')}}</div>
                                                              <div class="text-muted">{{$data['map']->UpdatedBy->name??''}}</div>
                                                            </div>
                                                        </li>

                                                    </ul>
                                                    @if(auth()->user()->hasPermissionTo('page_edit'))
                                                    <div class="mt-3">
                                                        <form action="{{route('contactus.edit','contactus')}}" method="get">
                                                            <button class="btn btn-primary" type="submit">{{__("Edit")}}</button>
                                                        </form>
                                                    </div>
                                                    @endif
                                                </div>
                                                <!-- card-body -->

                                            </div>
                                            <!-- end card -->
                                        </div>
                                        <div class="col-md-2 col-xs-12"></div>
                                    </div>
                                    <!-- end row -->

                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end container -->
                    </div>
                    <!-- end blog-page -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection

@section('custom_js')


@endsection
