@extends('backend.layouts.app')
@section('title','Home Edit')
@section('home-active','mm-active active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Home Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('home.show','home')}}">Home</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="home-form" action="{{ route('home.update', \Crypt::encrypt($home->id)) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="row">
                        <div class="col-md-8 col-xl-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{$home->title}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{$home->title_mm}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body">{{("Body(English)")}}<span class="text-danger">*</span></label>
                                                {{-- <input type="hidden" class="body_en" name="body" >
                                                <div id="body_en"></div> --}}
                                                <textarea class="elm1" name="body">{{$home->body??old('body')}}</textarea>
                                                @error('body')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body_mm">{{("Body(Myanmar)")}}<span class="text-danger">*</span></label>
                                                {{-- <input type="hidden"  class="body_mm" name="body_mm" />
                                                <div id="body_mm"></div> --}}
                                                <textarea class="elm1" name="body_mm">{{$home->body_mm??old('body_mm')}}</textarea>
                                                @error('body_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "link_to">{{("Button Link")}}<span class="text-danger">*</span></label>
                                                <select name="link_to" class="form-control">
                                                    <option value="">--Choose Menu--</option>
                                                    @foreach ($menus as $menu)
                                                        <option value="{{$menu->id}}"
                                                            {{$menu->id==$home->link_to?'selected':''}}
                                                            >{{session()->get('locale')=='en'?$menu->label:$menu->label_mm}}</option>
                                                    @endforeach
                                                </select>
                                                @error('link_to')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "meta_keyword">{{("Meta Keyword")}}</label>
                                                <input type="text" name="meta_keyword" class="form-control" value="{{$home->meta_keyword}}">
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body_mm">{{("Meta Description")}}</label>
                                                <textarea name="meta_description" class="form-control"> {{$home->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->

                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')

<script>
    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;
        frame.src = "";
    }
    {{--
    var body={!! $home->body !!};

    /** body english **/
    const editor = new EditorJS({
        /**
         * Id of Element that should contain Editor instance
         */
        holder: 'body_en',
        placeholder: 'Type here ...',
        tools:tools,
        data:body,
        onReady: ()=>{
            savedBody();
        },
        onChange:() =>{
            savedBody();
        }
    });
    function savedBody(){
        editor.save().then((bodyData) =>{
            var arr=JSON.stringify(bodyData);
            $('.body_en').val(arr);

        }).catch((error) =>{
            Swal.fire({
                position: 'top-end',
                icon: 'danger',
                title:error,
                showConfirmButton: false,
                timer: 1000
                });
        });

    }
    /**body myanmar**/
    var body_mm={!! $home->body_mm !!};
    const editor_mm = new EditorJS({
        /**
         * Id of Element that should contain Editor instance
         */
        holder: 'body_mm',
        placeholder: 'Type here ...',
        tools:tools,
        data:body_mm,
        onReady: ()=>{
            savedBodyMM();
        },
        onChange:() =>{
            savedBodyMM();
        }
    });
    function savedBodyMM(){
        editor_mm.save().then((bodyMMData) =>{
            var arr=JSON.stringify(bodyMMData)
            $('.body_mm').val(arr);
        }).catch((error) =>{
            Swal.fire({
                position: 'top-end',
                icon: 'danger',
                title:error,
                showConfirmButton: false,
                timer: 1000
                });
        });

    }
    --}}

</script>
@endsection
