@extends('backend.layouts.app')
@section('title','Company Edit')
@section('org-active','mm-active active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Company Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('organization.show','org')}}">Company</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="org-form" action="{{ route('organization.update', \Crypt::encrypt($org->id)) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="row">
                        <div class="col-md-8 col-xs-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body">{{("Body(English)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body">{{$org->body}}</textarea>
                                                @error('body')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body_mm">{{("Body(Myanmar)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body_mm">{{$org->body_mm}}</textarea>
                                                @error('body_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-4 col-xs-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                @if($org->feature_image != null && Storage::disk('public')->has($org->feature_image))
                                                    <img id="frame" width="50%" src="{{ asset('storage/'.$org->feature_image) }}"  class="img-fluid" />
                                                @else
                                                    <img id="frame" width="50%" src="" class="img-fluid" />
                                                @endif

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">{{__("Feature Image")}}</label>
                                                <input class="form-control @error('feature_image') is-invalid @enderror" type="file" name="feature_image" id="formFile" onchange="preview()">
                                                @error('feature_image')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">{{__("Meta Keyword")}}</label>
                                                <input class="form-control @error('meta_keyword') is-invalid @enderror" type="text" name="meta_keyword" value="{{$org->meta_keyword}}">
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">{{__("Meta Description")}}</label>
                                                <textarea class="form-control @error('meta_description') is-invalid @enderror"  name="meta_description" >{{$org->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')

<script>
    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;
        frame.src = "";
    }


</script>
@endsection
