@extends('backend.layouts.app')
@section('title','Company Detail')
@section('org-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Company Detail")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{__("Company")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Detail")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div id="main-content" class="blog-page">
                        <div class="container">
                            <div class="row clearfix">
                                <div class="col-lg-12 col-md-12 left-box">
                                    <div class="card single_org">
                                        <div class="card-body">

                                                @if($org->feature_image != null && Storage::disk('public')->has($org->feature_image))
                                                <div class="img-post p-5">
                                                    <img id="frame" width="50%" src="{{ asset('storage/'.$org->feature_image) }}"  class="img-fluid" />
                                                </div>

                                                @endif


                                            <ul class="list-group list-group-light">

                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Menu')}}</div>
                                                        <div class="text-muted">
                                                            @if(isset($org->menuItem->label))
                                                            {{session()->get('locale')=='en'?$org->menuItem->label:$org->menuItem->label_mm}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Body(English)')}}</div>
                                                        <div class="text-muted">
                                                            <div id="body_en"><?php echo $org->body ?></div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Body(Myanmar)')}}</div>
                                                        <div class="text-muted">
                                                            <div id="body_mm"><?php echo $org->body_mm ?></div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Meta Keyword')}}</div>
                                                      <div class="text-muted">{{$org->meta_keyword??''}}</div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Meta Description')}}</div>
                                                      <div class="text-muted">{{$org->meta_description??''}}</div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Created By')}}</div>
                                                      <div class="text-muted">{{$org->CreatedBy->name??''}}</div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                      <div class="fw-bold">{{__('Updated By')}}</div>
                                                      <div class="text-muted">{{$org->UpdatedBy->name??''}}</div>
                                                    </div>
                                                </li>
                                            </ul>
                                            @if(auth()->user()->hasPermissionTo('page_edit'))
                                            <div class="mt-3">
                                                <form action="{{route('organization.edit','org')}}" method="get">

                                                    <button class="btn btn-primary" type="submit">{{__("Edit")}}</button>
                                                </form>
                                            </div>
                                            @endif
                                        </div>
                                        <!-- card-body -->

                                    </div>
                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end container -->
                    </div>
                    <!-- end blog-page -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection

@section('custom_js')
@include('backend.common.changestatus',['url'=>'change-post-status'])
@include('backend.common.convertjson-tohtml')
@endsection
