@extends('backend.layouts.app')
@section('title', 'Suggestion List')
@section('suggestion-active', 'active')
@section('custom_css')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Suggestion List') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Suggestion') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{ __('List') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <form action="" method="get" class="form myform">
                                            @csrf
                                            <input type="hidden" name="order_by" value="suggestions.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="search"
                                                            placeholder="Search"
                                                            value="{{ $input['search'] ?? old('search') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="dates"
                                                            placeholder="Suggestion Date"
                                                            value="{{ $input['dates'] ?? old('dates') }}">
                                                    </div>
                                                </div>

                                                <div class="col-md-3 col-xs-3">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end col -->
                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0" id="myTable">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th class="order-by order-by-arrow suggestions-name"><span
                                                        class='suggestions.name'>{{ __('Name') }}</span></th>

                                                <th class="order-by order-by-arrow suggestions-phone"><span
                                                        class='suggestions.phone'>{{ __('Phone') }}</span></th>

                                                <th class="order-by order-by-arrow suggestions-nrc"><span
                                                        class='suggestions.nrc'>{{ __('NRC') }}</span></th>

                                                <th class="order-by order-by-arrow suggestions-address"><span
                                                        class='suggestions.address'>{{ __('Address') }}</span></th>

                                                <th class="order-by order-by-arrow suggestions-created_at"><span
                                                        class='suggestions.created_at'>{{ __('Suggestion Date') }}</span>
                                                </th>

                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($suggestions as $key => $suggestion)
                                                <tr>
                                                    <th scope="row">{{ $suggestions->firstItem() + $key }}</th>
                                                    <td>{{ $suggestion->name }}</td>
                                                    <td>{{ $suggestion->phone }}</td>
                                                    <td>{{ $suggestion->nrc }}</td>
                                                    <td>{{ $suggestion->address }}</td>
                                                    <td>{{ $suggestion->created_at ? date($date_format->value, strtotime($suggestion->created_at)) : '' }}
                                                    </td>

                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('page_list'))
                                                            <a href="{{ route('suggestion.show', \Crypt::encrypt($suggestion->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if (Auth::id() == 2 || Auth::id() == 1)
                                                            <a href="javascript:void(0);" class="text-danger delete-record"
                                                                data-bs-placement="top" title="Delete"
                                                                data-id="{{ \Crypt::encrypt($suggestion->id) }}"
                                                                data-action="{{ route('suggestion.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif

                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $suggestions->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')
    <script>
        $('input[name="dates"]').daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear',
            }
        });
        $('input[name="dates"]').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
        });

        $('input[name="dates"]').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
    </script>
@endsection
