@extends('backend.layouts.app')
@section('title','Suggestion Detail')
@section('suggestion-active','mm-active active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('fail'))
                    <div class="alert alert-danger">
                        {{ session()->get('fail') }}
                    </div>
                @endif
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Suggestion Detail")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('suggestion.index')}}">{{__("Suggestion")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Detail")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="container py-5">
                        <div class="row">
                            <div class="col-lg-5">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Name")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->name}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Phone")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->phone}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("NRC")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->nrc}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        {{--  <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Mail")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->email}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>  --}}
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Address")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->address}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>

                                    </div>
                                    <!-- end card-body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <div class="col-lg-7">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12">
                                                <strong class="mb-0">{{__("Message")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$suggestion->message}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        {{--  <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Files")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <div class="row justify-content-left">
                                                    @if(isset($suggestion->fileFiles))
                                                        @foreach($suggestion->fileFiles as $key=>$pfile)
                                                        @php
                                                            $file=$pfile->file_url;
                                                            $extension = pathinfo($file, PATHINFO_EXTENSION);
                                                        @endphp
                                                        <div class="border m-1 col-3 text-center">
                                                            @if(Storage::exists('public/'.$file))
                                                            <a class="btn preview_modal" href="" data-bs-toggle="modal" data-bs-target=".fileModal"  data-bs-file="{{$file}}" data-bs-extension="{{$extension}}" >
                                                                @if( $extension=='pdf')
                                                                    <img style="width:100%;height:100%;" src="{{ asset('backend/images/no-image.svg') }}" alt="" class="img-thumbnail">
                                                                @else
                                                                    <img style="width:100%;height:100%;" src="{{ asset('/storage/'.$file) }}"  class="img-thumbnail">
                                                                @endif
                                                            </a>
                                                            @endif
                                                        </div>

                                                        @endforeach
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>  --}}

                                    </div>
                                    <!-- end card-body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div>
                    <!-- end container -->
                </div>
                <!-- end row -->
                @include('backend.common.modal')
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
@include('backend.common.modaljs')
@endsection
