@extends('backend.layouts.app')
@section('title','Suggestion Create')
@section('suggestion-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Suggestion Create</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('suggestion.index')}}">Suggestion</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="suggestion-form" action="{{ route('suggestion.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">{{__("Name")}} <span class="text-danger">*</span></label>
                                                <input  type="text" class="form-control  @error('name') is-invalid @enderror" name="name"
                                                    placeholder="Name" value="{{old('name')}}" >
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="phone" class="form-label">{{__("Phone")}} <span class="text-danger">*</span></label>
                                                <input  type="phone" class="form-control  @error('phone') is-invalid @enderror" name="phone"
                                                    placeholder="Phone" value="{{old('phone')}}" >
                                                @error('phone')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="nrc" class="form-label">{{__("NRC")}} <span class="text-danger">*</span></label>
                                                <input  type="nrc" class="form-control  @error('nrc') is-invalid @enderror" name="nrc"
                                                    placeholder="NRC" value="{{old('nrc')}}" >
                                                @error('nrc')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">{{__("Email")}} <span class="text-danger">*</span></label>
                                                <input  type="email" class="form-control  @error('email') is-invalid @enderror" name="email"
                                                    placeholder="Suggestion Email" value="{{old('email')}}" >
                                                @error('email')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="address" class="form-label">{{__("Address")}} <span class="text-danger">*</span></label>
                                                <textarea class="form-control @error('address') is-invalid @enderror" name="address" >{{old('address')}}</textarea>

                                                @error('address')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="message" class="form-label">{{__("Message")}} <span class="text-danger">*</span></label>
                                                <textarea class="form-control @error('message') is-invalid @enderror" name="message" >{{old('message')}}</textarea>

                                                @error('message')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                <img id="frame" width="50%" src="" class="img-fluid" />
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">Files(PDF)<span class="text-danger">*</span></label>
                                                <input class="form-control @error('files') is-invalid @enderror" type="file" name="files[]" multiple>
                                                @error('files')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->


                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
<script>
    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;
        frame.src = "";
    }
    //if you want get value
  function getValue()
  {
   var value=$('#is_active').prop('checked')==true?'active':'inactive';
   var append=`<input type="hidden" name="status" value=`+value+`>`;
   $('.suggestion-form').append(append);
  }
</script>
@endsection
