@extends('backend.layouts.app')
@section('title','Post Create')
@section('post-active','active')
@section('custom_css')
{{-- <link rel="stylesheet" href="{{asset('backend/libs/editorjs/paragraph/src/index.css')}}"> --}}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Post Create")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('post.index')}}">{{__("Post")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Create")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="post-form" action="{{ route('post.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    @csrf
                    <div class="row">
                        <div class="col-md-8 col-xl-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="menu_item" class="form-label">{{__("Menu")}} <span class="text-danger">*</span></label>
                                                <select required class="form-control" name="menu_item_id">
                                                    <option value="">--Choose Menu--</option>
                                                    @foreach ($post_menus as $post_menu)
                                                        <option value="{{$post_menu->id}}">
                                                            @if(session()->get('locale')=='en')
                                                                {{$post_menu->label}}
                                                            @else
                                                                {{$post_menu->label_mm}}
                                                            @endif
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('menu_item')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{old('title')}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{old('title_mm')}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body">{{("Body(English)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body"></textarea>
                                                @error('body')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body_mm">{{("Body(Myanmar)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body_mm"></textarea>
                                                @error('body_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input" type="checkbox" value="active"  name="status" checked id="is_active" onchange="getStatusValue()">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-4 col-xs-4">
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="mb-3 text-center">
                                                        <img id="frame" height="250px" src="" class="" />
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="Image" class="form-label">{{__("Feature Image")}}<span class="text-danger">*</span></label>
                                                        <input required class="form-control @error('feature_image') is-invalid @enderror" type="file" name="feature_image"  onchange="preview()">
                                                        @error('feature_image')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror

                                                    </div>
                                                </div>
                                                <!-- end col -->

                                                {{--  <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="files" class="form-label">{{__("Attached Files(Images/PDFs)")}}</label>
                                                        <input class="form-control @error('files') is-invalid @enderror" type="file" name="files[]"  multiple id="formFile" >
                                                        @error('files')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                        <a onclick="clearImage()" class="btn btn-primary mt-3">Clear Files</a>
                                                    </div>
                                                </div>  --}}
                                                <!-- end col -->
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="slider" class="form-label">{{__("Show on slider?")}}
                                                            <input class="form-check-input" type="checkbox" value="inactive"  name="slider"  id="slider" onchange="getSliderValue()">
                                                        </label>
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="meta_keyword" class="form-label">{{__("Meta Keyword")}}</label>
                                                        <input class="form-control @error('meta_keyword') is-invalid @enderror" type="text" name="meta_keyword"    >
                                                        @error('meta_keyword')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <!-- end col -->

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="meta_description" class="form-label">{{__("Meta Description")}}</label>
                                                        <textarea class="form-control @error('meta_description') is-invalid @enderror"  name="meta_description" ></textarea>
                                                        @error('meta_description')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <!-- end col -->

                                            </div>
                                            <!-- end row -->
                                        </div>
                                    </div>
                                    <!-- end card -->
                                </div>

                            </div>

                        </div>
                        <!-- end col -->

                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')

<script>

    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;

    }
    //if you want get value
    function getStatusValue()
    {
        var value=$('#is_active').prop('checked')==true?'active':'inactive';
        var append=`<input type="hidden" name="status" value=`+value+`>`;
        $('.post-form').append(append);
    }
    function getSliderValue()
    {
        var value=$('#slider').prop('checked')==true?'active':'inactive';
        var append=`<input type="hidden" name="slider" value=`+value+`>`;
        $('.post-form').append(append);
    }



</script>
@endsection
