@extends('backend.layouts.app')
@section('title','Post Edit')
@section('post-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Post Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('post.index')}}">Post</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="post-form" action="{{ route('post.update', \Crypt::encrypt($post->id)) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="row">
                        <div class="col-md-8 col-xl-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="menu_item" class="form-label">{{__("Menu")}} <span class="text-danger">*</span></label>
                                                <select required class="form-control" name="menu_item">
                                                    <option value="">--Choose Menu--</option>
                                                    @foreach ($post_menus as $post_menu)
                                                        <option value="{{$post_menu->id}}" {{$post_menu->id==$post->menu_item_id?'selected':''}}>
                                                            @if(session()->get('locale')=='en')
                                                                {{$post_menu->label}}
                                                            @else
                                                                {{$post_menu->label_mm}}
                                                            @endif
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('menu_item')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{$post->title}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{$post->title_mm}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body">{{("Body(English)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body">{{$post->body}}</textarea>
                                                @error('body')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for = "body_mm">{{("Body(Myanmar)")}}<span class="text-danger">*</span></label>
                                                <textarea class="elm1" name="body_mm">{{$post->body_mm}}</textarea>
                                                @error('body_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input" type="checkbox" value="{{$post->status}}"  name="status" {{$post->status=='active'?'checked':''}} id="is_active" onchange="getStatusValue()">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-4 col-xl-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                @if(Storage::exists('public/'.$post->feature_image))
                                                    <img id="frame" height="250px" src="{{ asset('storage/'.$post->feature_image) }}"  class="" />
                                                @else
                                                    <img id="frame" height="250px" src="{{ asset('backend/images/no-image.png') }}"  class="" />
                                                @endif
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">{{__("Feature Image")}}</label>
                                                <input class="form-control @error('feature_image') is-invalid @enderror" type="file" name="feature_image" id="formFile" onchange="preview()">
                                                @error('feature_image')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        {{--  <div class="col-md-12" id="file_frame">
                                            <div class="row justify-content-center">
                                                @if(isset($post->fileFiles))
                                                    @foreach($post->fileFiles as $key=>$pfile)
                                                    @php
                                                        $file=$pfile->file_url;
                                                        $extension = pathinfo($file, PATHINFO_EXTENSION);
                                                    @endphp
                                                    @if(Storage::exists('public/'.$file))
                                                    <div class="border p-2 m-1 col-4 text-center">

                                                        <a class="btn preview_modal" href="" data-bs-toggle="modal" data-bs-target=".fileModal" data-bs-file="{{$file}}" data-bs-extension="{{$extension}}" >
                                                            @if( $extension=='pdf')
                                                                <img style="width:70px;height:70px;" src="{{ asset('backend/images/no-image.svg') }}" alt="" class="img-thumbnail" />
                                                            @else
                                                                <img style="width:70px;height:70px;" src="{{ asset('/storage/'.$file) }}"  class="img-thumbnail">
                                                            @endif
                                                        </a>
                                                        <div class="text-center">
                                                            <a class="btn btn-danger btn-sm delete_file" data-id="{{\Crypt::encrypt($pfile->id)}}"><i class="mdi mdi-trash-can"></i></a>
                                                        </div>

                                                    </div>
                                                    @endif

                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>  --}}
                                        <!-- end col -->
                                        {{--  <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="files" class="form-label">{{__("Attached Files(Images/PDFs)")}}</label>
                                                <input class="form-control @error('files') is-invalid @enderror" type="file" name="files[]" id="formFile" multiple>
                                                @error('files')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>  --}}
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="slider" class="form-label">{{__("Show on slider?")}}
                                                    <input class="form-check-input" type="checkbox" value="{{$post->slider}}"  name="slider" {{$post->slider=='active'?'checked':''}} id="slider" onchange="getSliderValue()">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_keyword" class="form-label">{{__("Meta Keyword")}}</label>
                                                <input class="form-control @error('meta_keyword') is-invalid @enderror" type="text" name="meta_keyword" value="{{$post->meta_keyword}}" >
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_description" class="form-label">{{__("Meta Description")}}</label>
                                                <textarea class="form-control @error('meta_description') is-invalid @enderror" name="meta_description" >{{$post->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
                @include('backend.common.modal')
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
@include('backend.common.modaljs')
<script>
    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;
        frame.src = "";
    }
    //if you want get value
    getStatusValue()
    function getStatusValue()
    {
        var value=$('#is_active').prop('checked')==true?'active':'inactive';
        console.log(value);
        var append=`<input type="hidden" name="status" value=`+value+`>`;
        $('.post-form').append(append);
    }
    getSliderValue()
    function getSliderValue()
    {
        var value=$('#slider').prop('checked')==true?'active':'inactive';
        var append=`<input type="hidden" name="slider" value=`+value+`>`;
        $('.post-form').append(append);
    }

    <!-- delete one file -->
    $('.delete_file').click(function(){
        Swal.fire({
            title: "Are you sure?",
            text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            })
            .then((result) => {
                if (result.isConfirmed)
                {
                    var id=$(this).attr('data-id');
                    var url = "{{route('get-decrypt-id')}}";
                    $.ajax({
                            url: url,
                            method: 'POST',
                            data: {id:id},
                            success: function(data) {
                                var url = "{{route('post-file-destroy')}}";
                                $.ajax({
                                        url: url,
                                        method: 'POST',
                                        data: {id:data.id},
                                        success: function(data) {
                                            window.location.reload();
                                        }
                                });
                            }
                        });

                }
            });


        });
</script>
@endsection
