@extends('backend.layouts.app')
@section('title', 'Post List')
@section('post-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Post List') }}</h4>

                            {{--  <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{__("Post")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("List")}}</li>
                                </ol>
                            </div>  --}}

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    @if (auth()->user()->hasPermissionTo('post_create'))
                        <div class="">
                            <div class="float-md-end">
                                <form action="{{ route('post.create') }}" class="form" method="get">
                                    <div class="mb-4">
                                        <button type="submit" class="btn btn-success waves-effect waves-light"> <i
                                                class="mdi mdi-plus me-2"></i>Add Post</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- end col -->
                    @endif
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <form action="" method="get" class="form myform">
                                            @csrf
                                            <input type="hidden" name="order_by" value="posts.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="search"
                                                            placeholder="Search"
                                                            value="{{ $input['search'] ?? old('search') }}">
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-2 col-xs-2">
                                                    <div class="mb-4">
                                                        <select class="form-control" name="menu_item_id">
                                                            <option value="">--Select Category--</option>
                                                            @foreach ($postMenus as $postMenu)
                                                                <option value="{{ $postMenu->id }}"
                                                                    {{ $menu_item_id == $postMenu->id ? 'selected' : '' }}>
                                                                    @if (session()->get('locale') == 'mm')
                                                                        {{ $postMenu->label_mm }}
                                                                    @else
                                                                        {{ $postMenu->label }}
                                                                    @endif
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-2 col-xs-2">
                                                    <div class="mb-4">
                                                        <select class="form-control" name="status">
                                                            <option value="">--Select Status--</option>
                                                            <option value='active'
                                                                {{ isset($input['status']) && $input['status'] == 'active' ? 'selected' : '' }}>
                                                                {{ __('Active') }}</option>
                                                            <option value='inactive'
                                                                {{ isset($input['status']) && $input['status'] == 'inactive' ? 'selected' : '' }}>
                                                                {{ __('Inactive') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-2 col-xs-2">
                                                    <div class="mb-4">
                                                        <select class="form-control" name="slider">
                                                            <option value="">--Select Slider Status--</option>
                                                            <option value='active'
                                                                {{ isset($input['slider']) && $input['slider'] == 'active' ? 'selected' : '' }}>
                                                                {{ __('Active') }}</option>
                                                            <option value='inactive'
                                                                {{ isset($input['slider']) && $input['slider'] == 'inactive' ? 'selected' : '' }}>
                                                                {{ __('Inactive') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                                <div class="col-md-2 col-xs-2">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end col -->
                                            </div>
                                            <!-- end col -->
                                        </form>
                                    </div>
                                    <!-- end col -->

                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0" id="myTable">

                                        <thead>
                                            <tr>
                                                <th>{{ __('No') }}</th>
                                                <th>{{ __('Feature Image') }}</th>
                                                @if (session()->get('locale') == 'mm')
                                                    <th class="order-by order-by-arrow posts-title_mm"><span
                                                            class='posts.title_mm'>{{ __('Title') }}</span></th>
                                                @else
                                                    <th class="order-by order-by-arrow posts-title"><span
                                                            class='posts.title'>{{ __('Title') }}</span></th>
                                                @endif

                                                <th class="order-by order-by-arrow posts-meta_keyword"><span
                                                        class='posts.meta_keyword'>{{ __('Meta Keyword') }}</span></th>
                                                <th>{{ __('Menu') }}</th>
                                                <th>{{ __('Show On Slider') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Created By') }}</th>
                                                <th>{{ __('Updated By') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($posts as $key => $post)
                                                <tr>
                                                    <th scope="row">{{ $posts->firstItem() + $key }}</th>
                                                    <td>
                                                        @if (isset($post->feature_image) && Storage::disk('public')->exists($post->feature_image))
                                                            <img class="" style="height:80px;"
                                                                src="{{ asset('storage/' . $post->feature_image) }}"
                                                                alt="">
                                                        @else
                                                            <img class="" style="height:80px;"
                                                                src="{{ asset('backend/images/admin_avatar.png') }}"
                                                                alt="">
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if (session()->get('locale') == 'mm')
                                                            {{ $post->title_mm }}
                                                        @else
                                                            {{ $post->title }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{ $post->meta_keyword }}
                                                    </td>
                                                    <td>
                                                        @if (session()->get('locale') == 'en')
                                                            {{ $post->menuItem->label }}
                                                        @else
                                                            {{ $post->menuItem->label_mm }}
                                                        @endif

                                                    </td>

                                                    <td>
                                                        {{ ucfirst($post->slider) }}</td>
                                                    <td>
                                                        <input class="toggle-trigger" type="checkbox"
                                                            {{ $post->status == 'active' ? 'checked' : '' }}
                                                            data-toggle="toggle" data-onstyle="success"
                                                            data-offstyle="danger"
                                                            data-id="{{ \Crypt::encrypt($post->id) }}" value=""
                                                            name="status"
                                                            @if (!auth()->user()->hasPermissionTo('post_status')) disabled @endif>
                                                    </td>
                                                    <td>{{ $post->CreatedBy->name }}</td>
                                                    <td>{{ $post->UpdatedBy->name ?? '' }}</td>
                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('post_list'))
                                                            <a href="{{ route('post.show', \Crypt::encrypt($post->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('post_edit'))
                                                            <a href="{{ route('post.edit', \Crypt::encrypt($post->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="Edit"><i
                                                                    class="mdi mdi-pencil font-size-18"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('post_delete'))
                                                            <a href="javascript:void(0);"
                                                                class="text-danger delete-record" data-bs-placement="top"
                                                                title="Delete" data-id="{{ \Crypt::encrypt($post->id) }}"
                                                                data-action="{{ route('post.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $posts->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')
    @include('backend.common.changestatus', ['url' => 'change-post-status'])

@endsection
