@extends('backend.layouts.app')
@section('title', 'Post Detail')
@section('post-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Post Detail') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ route('post.index') }}">{{ __('Post') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{ __('Detail') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div id="main-content" class="blog-page">
                        <div class="container">
                            <div class="row clearfix">
                                <div class="col-lg-4 col-md-12 left-box">
                                    <div class="card single_post">
                                        <div class="card-body">
                                            <div class="img-post p-5">
                                                @if (Storage::exists('public/' . $post->feature_image))
                                                    <img class="d-block img-fluid"
                                                        src="{{ asset('storage/' . $post->feature_image) }}"
                                                        alt="Feature Image">
                                                @else
                                                    <img class="d-block img-fluid"
                                                        src="{{ asset('backend/images/no-image.png') }}"
                                                        alt="Feature Image">
                                                @endif
                                            </div>
                                            <ul class="list-group list-group-light">
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Title(English)') }}</div>
                                                        <div class="text-muted">{{ $post->title }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Title(Myanmar)') }}</div>
                                                        <div class="text-muted">{{ $post->title_mm }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Is Active?') }}</div>
                                                        <div class="text-muted">{{ $post->status }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Show on Slider?') }}</div>
                                                        <div class="text-muted">{{ $post->slider }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Created By') }}</div>
                                                        <div class="text-muted">{{ $post->CreatedBy->name ?? '' }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Updated By') }}</div>
                                                        <div class="text-muted">{{ $post->UpdatedBy->name ?? '' }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Menu') }}</div>
                                                        <div class="text-muted">
                                                            {{ session()->get('locale') == 'en' ? $post->menuItem->label : $post->menuItem->label_mm }}
                                                        </div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Meta Keyword') }}</div>
                                                        <div class="text-muted">{{ $post->meta_keyword }}</div>
                                                    </div>
                                                </li>
                                                <li
                                                    class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-bold">{{ __('Meta Description') }}</div>
                                                        <div class="text-muted">{{ $post->meta_description }}</div>
                                                    </div>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-8 col-md-12 right-box">

                                    <div class="card">
                                        <div class="card-body widget">
                                            <h4 class="pro-d-title">
                                                {{ __('Body (English)') }}
                                            </h4>
                                            <div><?php echo $post->body; ?></div>

                                            <hr>
                                            <h4 class="pro-d-title">
                                                {{ __('Body (Myanmar)') }}
                                            </h4>
                                            <div><?php echo $post->body_mm; ?></div>
                                            <hr>
                                            {{-- <h4 class="pro-d-title">
                                                {{__("Attached Files")}}
                                            </h4>
                                            <div class="col-md-12" id="file_frame">
                                                <div class="row justify-content-left">
                                                    @if (isset($post->fileFiles))
                                                        @foreach ($post->fileFiles as $key => $pfile)
                                                        @php
                                                            $file=$pfile->file_url;
                                                            $extension = pathinfo($file, PATHINFO_EXTENSION);
                                                        @endphp
                                                        <div class="border m-1 col-3 text-center">
                                                            @if (Storage::exists('public/' . $file))
                                                            <a class="btn preview_modal" href="" data-bs-toggle="modal" data-bs-target=".fileModal" data-bs-file="{{$file}}" data-bs-extension="{{$extension}}" >
                                                                @if ($extension == 'pdf')
                                                                    <img style="width:100%;height:100%;" src="{{ asset('backend/images/no-image.svg') }}" alt="" class="img-thumbnail" />
                                                                @else
                                                                    <img style="width:100%;height:100%;" src="{{ asset('/storage/'.$file) }}"  class="img-thumbnail">
                                                                @endif
                                                            </a>
                                                        @endif
                                                        </div>

                                                        @endforeach
                                                    @endif
                                                </div>
                                            </div> --}}
                                            <!-- end col -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end container -->
                        @include('backend.common.modal')
                    </div>
                    <!-- end blog-page -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.changestatus', ['url' => 'change-post-status'])
    @include('backend.common.modaljs')
@endsection
