@extends('backend.layouts.app')
@section('title','Role Create')
@section('role-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Role Create</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('role.index')}}">Role</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('role.store') }}" method="POST" autocomplete="off">
                                    @csrf
                                    <div class="row mb-5">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">Role Name <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('name') is-invalid @enderror" name="name"
                                                    placeholder="Role Name" value="{{old('name')}}"  >
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            {{-- <p>@dump($errors)</p> --}}
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label for="validationCustom03" class="form-label @error('permissions') is-invalid @enderror">{{__("Permissions")}}<span class="text-danger">*</span></label>
                                                        @error('permissions')
                                                            <div class="invalid-feedback mb-3">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                    <!-- end col -->
                                                    <div class="col-md-9">
                                                        @foreach($permissions as $letter => $letterPermissions)
                                                            <div class="row ">
                                                                <div class="col-xs-4"></div>
                                                                @foreach($letterPermissions as $key=>$permission)
                                                                    <div class="col-xs-4 col-lg-4 col-sm-6 mb-3">
                                                                        <label><input type="checkbox" name="permissions[{{$permission->name}}]" class="" value="{{ $permission->name }}"
                                                                        {{old('permissions.'.$permission->name) == $permission->name?'checked':''}}
                                                                         > {{ $permission->name }}</label>
                                                                    </div>
                                                                    <!-- end col -->
                                                                @endforeach
                                                                <hr>
                                                            </div>
                                                            <!-- end row -->
                                                        @endforeach
                                                    </div>
                                                    <!-- end col -->
                                                </div>
                                                <!-- end row-->
                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->

                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </form>
                                <!-- end form -->
                            </div>
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
