@extends('backend.layouts.app')
@section('title', 'Role List')
@section('role-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Role List') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Role') }}</a></li>
                                    <li class="breadcrumb-item active">{{ __('List') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <form action="" method="get" class="form">
                                            @csrf
                                            <input type="hidden" name="order_by" value="roles.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="name"
                                                            placeholder="Role Name"
                                                            value="{{ $input['name'] ?? old('name') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end col -->
                                    @if (auth()->user()->hasPermissionTo('role_create'))
                                        <div class="col-md-4">
                                            <div class="float-md-end">
                                                <form action="{{ route('role.create') }}" class="form" method="get">
                                                    <div class="mb-4">
                                                        <button type="submit"
                                                            class="btn btn-success waves-effect waves-light"> <i
                                                                class="mdi mdi-plus me-2"></i>{{ __('Add Role') }}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    @endif
                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th>{{ __('No') }}</th>
                                                <th class="order-by order-by-arrow roles-name"><span
                                                        class='roles.name'>{{ __('Name') }}</span></th>
                                                <th>{{ __('Permissions') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($roles as $key => $role)
                                                <tr>
                                                    <th scope="row">{{ $roles->firstItem() + $key }}</th>
                                                    <td>{{ $role->name }}</td>
                                                    <td>
                                                        @foreach ($role->permissions as $key => $permission)
                                                            <span class="badge bg-primary">{{ $permission->name }}</span>
                                                            @if (($key + 1) % 8 == 0)
                                                                <br>
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('role_list'))
                                                            <a href="{{ route('role.show', \Crypt::encrypt($role->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if ($role->id != 1)
                                                        @if (auth()->user()->hasPermissionTo('role_edit'))
                                                            <a href="{{ route('role.edit', \Crypt::encrypt($role->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="Edit"><i
                                                                    class="mdi mdi-pencil font-size-18"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('role_delete'))
                                                            <a href="javascript:void(0);" class="text-danger delete-record"
                                                                data-bs-placement="top" title="Delete"
                                                                data-id="{{ \Crypt::encrypt($role->id) }}"
                                                                data-action="{{ route('role.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $roles->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')
@endsection
