@extends('backend.layouts.app')
@section('title','Role Detail')
@section('role-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('fail'))
                    <div class="alert alert-danger">
                        {{ session()->get('fail') }}
                    </div>
                @endif
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Role Information")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('role.index')}}">Role</a></li>
                                    <li class="breadcrumb-item active">{{__("Show")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <h5 class="badge bg-primary ">{{$role->name}}</h5>
                                        </div>
                                    </div>
                                    <!-- end col -->
                                </div>
                                <!-- end row -->
                                <div class="row">
                                    <div class="col-md-12">
                                        {{-- <p>@dump($errors)</p> --}}
                                        <div class="mb-3">
                                            <div class="row ">
                                                @foreach($role_permissions as $letter => $letterPermissions)
                                                    <div class="row ">
                                                        @foreach($letterPermissions as $permission)
                                                            <div class="col-xl-4 col-lg-4 col-sm-6 mb-3">
                                                                <label><p class="" > {{ $permission->name }}</p></label>
                                                            </div>
                                                            <!-- end col -->
                                                        @endforeach
                                                        <hr>
                                                    </div>
                                                    <!-- end row -->
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end col -->

                                </div>
                                <!-- end row -->
                            </div>
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection

