@extends('backend.layouts.app')
@section('title', 'Setting Edit')
@section('setting-active', 'mm-active active')
@section('custom_css')
    <style>
        .img-wrapper {
            position: relative;
            width: 100%;
        }

        .img-overlay {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
        }

        .img-overlay:before {
            content: ' ';
            display: block;
            /* adjust 'height' to position overlay content vertically */
            height: 33%;
        }

        .change_image {
            background: #bfc8c5;
            opacity: 0.5;
            height: 30%;
            color: black;
            vertical-align: middle;
        }
    </style>
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                @include('backend.common.message')
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __("Setting Edit") }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ route('setting.show', 'setting') }}">Setting</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{ __("Edit") }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="setting-form" action="{{ route('setting.update', \Crypt::encrypt(1)) }}" method="POST"
                    enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 col-xs-12">
                                    <div class="mb-3 text-center">
                                        <label for=""
                                            class="">{{ $data['favicon']['display_name'] }}(.png)</label>
                                        <div class="img-wrapper">
                                            <div class="upload-preview">
                                                @if (isset($data['favicon']['value']) && Storage::disk('public')->exists($data['favicon']['value']))
                                                    <img height="100px"
                                                        src="{{ asset('storage/' . $data['favicon']['value']) }}"
                                                        class="upload-img" />
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm position-absolute top-0 end-0"
                                                        onclick="deleteImage('favicon')"><i
                                                            class="ri-delete-bin-line"></i></button>
                                                @else
                                                    <img height="100px" class="upload-img"
                                                        src="{{ asset(Setting::FAVICON_ICON) }}" alt="">
                                                @endif
                                            </div>
                                            <div class="mt-3">
                                                <input class="file form-control" name="favicon" type="file">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col -->

                                <div class="col-md-4 col-xs-12">
                                    <div class="mb-3 text-center">
                                        <label for=""
                                            class="">{{ $data['left_logo']['display_name'] }}</label>
                                        <div class="img-wrapper">
                                            <div class="upload-preview">
                                                @if (isset($data['left_logo']['value']) && Storage::disk('public')->exists($data['left_logo']['value']))
                                                    <img height="100px"
                                                        src="{{ asset('storage/' . $data['left_logo']['value']) }}"
                                                        class="upload-img" />
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm position-absolute top-0 end-0"
                                                        onclick="deleteImage('left_logo')"><i
                                                            class="ri-delete-bin-line"></i></button>
                                                @else
                                                    <img height="100px" class="upload-img"
                                                        src="{{ asset(Setting::LEFT_LOGO) }}" alt="">
                                                @endif
                                            </div>
                                            <div class="mt-3">
                                                <input class="file form-control" type="file" name="left_logo">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col -->

                                <!-- <div class="col-md-3 col-xs-12">
                                    <div class="mb-3 text-center">
                                        <label for=""
                                            class="">{{ $data['right_logo']['display_name'] }}</label>
                                        <div class="img-wrapper">
                                            <div class="upload-preview">
                                                @if (isset($data['right_logo']['value']) && Storage::disk('public')->exists($data['right_logo']['value']))
                                                    <img height="100px"
                                                        src="{{ asset('storage/' . $data['right_logo']['value']) }}"
                                                        class="upload-img" />
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm position-absolute top-0 end-0"
                                                        onclick="deleteImage('right_logo')"><i
                                                            class="ri-delete-bin-line"></i></button>
                                                @else
                                                    <img height="100px" class="upload-img"
                                                        src="{{ asset(Setting::RIGHT_LOGO) }}" alt="">
                                                @endif
                                            </div>
                                            <div class="mt-3">
                                                <input class="file form-control" type="file" name="right_logo">
                                            </div>
                                        </div>
                                    </div>
                                </div> -->
                                <!-- end col -->

                                <div class="col-md-4 col-xs-12">
                                    <div class="mb-3 text-center">
                                        <label for=""
                                            class="">{{ $data['site_logo']['display_name'] }}</label>
                                        <div class="img-wrapper">
                                            <div class="upload-preview">
                                                @if (isset($data['site_logo']['value']) && Storage::disk('public')->exists($data['site_logo']['value']))
                                                    <img height="100px"
                                                        src="{{ asset('storage/' . $data['site_logo']['value']) }}"
                                                        class="upload-img" />
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm position-absolute top-0 end-0"
                                                        onclick="deleteImage('site_logo')"><i
                                                            class="ri-delete-bin-line"></i></button>
                                                @else
                                                    <img height="100px" class="upload-img"
                                                        src="{{ asset(Setting::SITE_LOGO) }}" alt="">
                                                @endif
                                            </div>
                                            <div class="mt-3">
                                                <input class="file form-control" type="file" name="site_logo">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->

                            <hr class="my-5">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="main_title_en"
                                            class="form-label">{{ $data['main_title_en']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('main_title_en') is-invalid @enderror"
                                            name="main_title_en" value="{{ $data['main_title_en']['value'] }}" />
                                        @error('main_title_en')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="main_title_mm"
                                            class="form-label">{{ $data['main_title_mm']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('main_title_mm') is-invalid @enderror"
                                            name="main_title_mm" value="{{ $data['main_title_mm']['value'] }}" />
                                        @error('main_title_mm')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="sub_title_en"
                                            class="form-label">{{ $data['sub_title_en']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('sub_title_en') is-invalid @enderror"
                                            name="sub_title_en" value="{{ $data['sub_title_en']['value'] }}" />
                                        @error('sub_title_en')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="sub_title_mm"
                                            class="form-label">{{ $data['sub_title_mm']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('sub_title_mm') is-invalid @enderror"
                                            name="sub_title_mm" value="{{ $data['sub_title_mm']['value'] }}" />
                                        @error('sub_title_mm')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->
                            {{--  <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="phone_number" class="form-label">{{$data['phone_number']['display_name']}}<span class="text-danger">*</span></label>
                                        <input required type="text" class="form-control @error('phone_number') is-invalid @enderror"  name="phone_number" value="{{$data['phone_number']['value']}}" />
                                        @error('phone_number')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">{{$data['email']['display_name']}}<span class="text-danger">*</span></label>
                                        <input required type="text" class="form-control @error('email') is-invalid @enderror"  name="email" value="{{$data['email']['value']}}" />
                                        @error('email')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->  --}}
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="site_name_en"
                                            class="form-label">{{ $data['site_name_en']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('site_name_en') is-invalid @enderror"
                                            name="site_name_en" value="{{ $data['site_name_en']['value'] }}" />
                                        @error('site_name_en')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="site_name_mm"
                                            class="form-label">{{ $data['site_name_mm']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('site_name_mm') is-invalid @enderror"
                                            name="site_name_mm" value="{{ $data['site_name_mm']['value'] }}" />
                                        @error('site_name_mm')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->

                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="date_format"
                                            class="form-label">{{ $data['date_format']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <select required name="date_format"
                                            class="form-control @error('date_format') is-invalid @enderror">
                                            <option value="">--Choose Date Format--</option>
                                            @foreach ($dateFormats as $key => $format)
                                                <option value="{{ $key }}"
                                                    {{ $key == $data['date_format']['value'] ? 'selected' : '' }}>
                                                    {{ $format }}</option>
                                            @endforeach
                                        </select>
                                        @error('date_format')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="language"
                                            class="form-label">{{ $data['language']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <select required name="language"
                                            class="form-control @error('language') is-invalid @enderror">
                                            <option value="">--Choose Date Format--</option>

                                            <option value="en" {{ $locale == 'en' ? 'selected' : '' }}>
                                                {{ __('English') }}</option>
                                            <option value="mm" {{ $locale == 'mm' ? 'selected' : '' }}>
                                                {{ __('Myanmar') }}</option>
                                        </select>
                                        @error('language')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                            {{--  <hr class="my-5">  --}}
                            {{--  <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="robots" class="form-label">{{$data['robots']['display_name']}}</label>
                                        <a class="btn " href="{{asset('robots.txt')}}" download><i class=" ri-download-cloud-2-line"></i></a>
                                        <input type="file" class="form-control @error('robots') is-invalid @enderror"  name="robots" />
                                        @error('robots')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="sitemap" class="form-label">{{$data['sitemap']['display_name']}}</label>
                                        <a class="btn " href="{{asset('sitemap.xml')}}" download><i class=" ri-download-cloud-2-line"></i></a>
                                        <input type="file" class="form-control @error('sitemap') is-invalid @enderror"  name="sitemap" />
                                        @error('sitemap')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                            </div>  --}}
                            <!-- end row -->
                            {{--  <hr class="my-5">  --}}
                            <hr class="my-5">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="row">
                                        {{--  <div class="col-md-12 col-xs-12">
                                            <div class="mb-3 ">
                                                <label for="" class="">{{$data['facebook_icon']['display_name']}}</label>
                                                <div class="img-wrapper d-flex">
                                                    <div class="upload-preview">
                                                        @if (isset($data['facebook_icon']['value']) && Storage::disk('public')->exists($data['facebook_icon']['value']))
                                                            <img height="100px" src="{{ asset('storage/'.$data['facebook_icon']['value']) }}" class="upload-img" />
                                                        @else
                                                            <img height="100px"  class="upload-img" src="{{ asset('backend/images/no-image.png') }}" alt="">
                                                        @endif
                                                    </div>
                                                    <div class="m-3" >
                                                      <input class="file form-control" name="facebook_icon" type="file">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  --}}
                                        <div class="col-md-12 col-xs-12">
                                            <div class="mb-3">
                                                <label for="facebook_link"
                                                    class="form-label">{{ $data['facebook_link']['display_name'] }}</label>
                                                <input type="text"
                                                    class="form-control @error('facebook_link') is-invalid @enderror"
                                                    name="facebook_link" value="{{ $data['facebook_link']['value'] }}" />
                                                @error('facebook_link')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="row">
                                        {{--  <div class="col-md-12 col-xs-12">
                                            <div class="mb-3">
                                                <label for="" class="">{{$data['youtube_icon']['display_name']}}</label>
                                                <div class="img-wrapper d-flex">
                                                    <div class="upload-preview">
                                                        @if (isset($data['youtube_icon']['value']) && Storage::disk('public')->exists($data['youtube_icon']['value']))
                                                            <img height="100px" src="{{ asset('storage/'.$data['youtube_icon']['value']) }}" class="upload-img" />
                                                        @else
                                                            <img height="100px"  class="upload-img" src="{{ asset('backend/images/no-image.png') }}" alt="">
                                                        @endif
                                                    </div>
                                                    <div class="m-3">
                                                      <input class="file form-control" name="youtube_icon" type="file">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  --}}
                                        <div class="col-md-12 col-xs-12">
                                            <div class="mb-3">
                                                <label for="youtube_link"
                                                    class="form-label">{{ $data['youtube_link']['display_name'] }}</label>
                                                <input type="text"
                                                    class="form-control @error('youtube_link') is-invalid @enderror"
                                                    name="youtube_link" value="{{ $data['youtube_link']['value'] }}" />
                                                @error('youtube_link')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- end col -->

                            </div>
                            <!-- end row -->
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="footer_text_en"
                                            class="form-label">{{ $data['footer_text_en']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('footer_text_en') is-invalid @enderror"
                                            name="footer_text_en" value="{{ $data['footer_text_en']['value'] }}" />
                                        @error('footer_text_en')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                                <div class="col-md-6 col-xs-12">
                                    <div class="mb-3">
                                        <label for="footer_text_mm"
                                            class="form-label">{{ $data['footer_text_mm']['display_name'] }}<span
                                                class="text-danger">*</span></label>
                                        <input required type="text"
                                            class="form-control @error('footer_text_mm') is-invalid @enderror"
                                            name="footer_text_mm" value="{{ $data['footer_text_mm']['value'] }}" />
                                        @error('footer_text_mm')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                            <div class="row">
                                <div class="col-md-12">
                                    <button class="btn btn-primary" type="submit">{{ __('Save') }}</button>
                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                        </div>
                        <!-- end card-body -->
                    </div>
                    <!-- end card -->
                </form>
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    <script>
        $(".file").change(function(event) {
            preview = $(this).parent().siblings('.upload-preview').find('.upload-img');
            var input = $(event.currentTarget);
            var file = input[0].files[0];
            var reader = new FileReader();
            reader.onload = function(e) {
                image_base64 = e.target.result;
                preview.attr("src", image_base64);
            };
            reader.readAsDataURL(file);
        });

        function deleteImage(logoName) {
            var url = "{{ route('setting-delete-image') }}";
            console.log(url);
            $('.setting-form').attr('action', url);
            $('input[name="_method"]').val('POST');
            $('.setting-form').append(`<input name="delete_image_type" value="` + logoName + `" />`);
            $('.setting-form').submit();
        }
    </script>
@endsection
