@extends('backend.layouts.app')
@section('title','User Create')
@section('user-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">User Create</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('user.index')}}">User</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="user-form" action="{{ route('user.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">{{__("User Name")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('name') is-invalid @enderror" name="name"
                                                    placeholder="User Name" value="{{old('name')}}" >
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">{{__("Email")}} <span class="text-danger">*</span></label>
                                                <input required type="email" class="form-control  @error('email') is-invalid @enderror" name="email"
                                                    placeholder="User Email" value="{{old('email')}}" >
                                                @error('email')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="role" class="form-label">
                                                    {{__("Role")}}<span class="text-danger">*</span>
                                                </label>
                                                <select required name="role" class="form-control @error('role') is-invalid @enderror">
                                                    <option value="">--Choose User Role--</option>
                                                    @foreach ($roles as $role)
                                                        <option value="{{$role->id}}" {{old('role')==$role->id?'selected':''}}>{{$role->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <label for="password" class="form-label">{{__("Password")}} <span class="text-danger">*</span></label>
                                            <div class="input-group mb-3">
                                                <input required type="password" class="form-control input-password @error('password') is-invalid @enderror" name="password"
                                                    placeholder="User Password" value="{{old('password')}}" >
                                                <button class="toggle-password" type="button"
                                                aria-label="Show password as plain text. Warning: this will display your password on the screen.">
                                                </button>
                                                @error('password')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>

                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <label for="password_confirm" class="form-label">{{__("Password Confirmation")}} <span class="text-danger">*</span></label>
                                            <div class="input-group mb-3">
                                                <input required type="password" class="form-control input-password @error('password') is-invalid @enderror" name="password_confirmation"
                                                placeholder="Password Confirmation" value="" >
                                                <button class="toggle-password" type="button"
                                                aria-label="Show password as plain text. Warning: this will display your password on the screen.">
                                                </button>
                                                @error('password')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>


                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="is_active" class="form-label">{{__("Is Active?")}}
                                                    <input class="form-check-input" type="checkbox" value="active"  name="status" checked id="is_active" onchange="getValue()">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                <img id="frame" height="250px" src="" class="" />
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">Profile Image</label>
                                                <input class="form-control @error('profile_image') is-invalid @enderror" type="file" name="profile_image" id="formFile" onchange="preview()">
                                                @error('profile_image')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                                <a onclick="clearImage()" class="btn btn-primary mt-3">Clear Image</a>

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->


                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
@include('common.showpassword')
<script>
    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
    function clearImage() {
        document.getElementById('formFile').value = null;
        frame.src = "";
    }
    //if you want get value
  function getValue()
  {
   var value=$('#is_active').prop('checked')==true?'active':'inactive';
   var append=`<input type="hidden" name="status" value=`+value+`>`;
   $('.user-form').append(append);
  }



</script>
@endsection
