@extends('backend.layouts.app')
@section('title', 'User List')
@section('user-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('User List') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('User') }}</a></li>
                                    <li class="breadcrumb-item active">{{ __('List') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <form action="" method="get" class="form myform">
                                            @csrf
                                            <input type="hidden" name="order_by" value="users.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="search"
                                                            placeholder="Search"
                                                            value="{{ $input['search'] ?? old('search') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <select class="form-control" name="status">
                                                            <option value="">--Select Status--</option>
                                                            <option value='active'
                                                                {{ isset($input['status']) && $input['status'] == 'active' ? 'selected' : '' }}>
                                                                {{ __('Active') }}</option>
                                                            <option value='inactive'
                                                                {{ isset($input['status']) && $input['status'] == 'inactive' ? 'selected' : '' }}>
                                                                {{ __('Inactive') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end col -->
                                    @if (auth()->user()->hasPermissionTo('user_create'))
                                        <div class="col-md-4">
                                            <div class="float-md-end">
                                                <form action="{{ route('user.create') }}" class="form" method="get">
                                                    <div class="mb-4">
                                                        <button type="submit"
                                                            class="btn btn-success waves-effect waves-light"> <i
                                                                class="mdi mdi-plus me-2"></i>Add User</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    @endif
                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0" id="myTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('No') }}</th>
                                                <th>{{ __('Profile Image') }}</th>
                                                <th class="order-by order-by-arrow users-name"><span
                                                        class='users.name'>{{ __('Name') }}</span></th>
                                                <th class="order-by order-by-arrow users-email"><span
                                                        class='users.email'>{{ __('Email') }}</span></th>
                                                <th>{{ __('Role') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Last Login') }}</th>
                                                <th>{{ __('Created By') }}</th>
                                                <th>{{ __('Updated By') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($users as $key => $user)
                                                <tr>
                                                    <th scope="row">{{ $users->firstItem() + $key }}</th>
                                                    <td>
                                                        @if (isset($user->profile_image) && Storage::disk('public')->exists($user->profile_image))
                                                            <img class="avatar-xs rounded-circle"
                                                                src="{{ asset('storage/' . $user->profile_image) }}"
                                                                alt="">
                                                        @else
                                                            <img class="avatar-xs rounded-circle"
                                                                src="{{ asset('backend/images/admin_avatar.png') }}"
                                                                alt="">
                                                        @endif
                                                    </td>
                                                    <td>{{ $user->name }}</td>
                                                    <td>{{ $user->email }}</td>
                                                    <td>
                                                        @foreach ($user->getRoleNames() as $role_name)
                                                            @if (!$loop->last)
                                                                {{ $role_name }},
                                                            @else
                                                                {{ $role_name }}
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        @if ($user->id != 2)
                                                        <input class="toggle-trigger" type="checkbox"
                                                            {{ $user->status == 'active' ? 'checked' : '' }}
                                                            data-toggle="toggle" data-onstyle="success"
                                                            data-offstyle="danger"
                                                            data-id="{{ \Crypt::encrypt($user->id) }}"
                                                            value="{{ $user->status }}" name="status"
                                                            @if (!auth()->user()->hasPermissionTo('user_status')) disabled @endif>
                                                        @endif
                                                    </td>
                                                    <td>{{ $user->login_at ? date($date_format->value, strtotime($user->login_at)) : '' }}
                                                    </td>
                                                    <td>{{ $user->CreatedBy->name ?? '' }}</td>
                                                    <td>{{ $user->UpdatedBy->name ?? '' }}</td>
                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('user_list'))
                                                            <a href="{{ route('user.show', \Crypt::encrypt($user->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('user_edit'))
                                                            <a href="{{ route('user.edit', \Crypt::encrypt($user->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="Edit"><i
                                                                    class="mdi mdi-pencil font-size-18"></i></a>
                                                        @endif
                                                        @can('user_delete')
                                                        @if ($user->id != 2)
                                                            <a href="javascript:void(0);" class="text-danger delete-record"
                                                                data-bs-placement="top" title="Delete"
                                                                data-id="{{ \Crypt::encrypt($user->id) }}"
                                                                data-action="{{ route('user.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif
                                                        @endcan
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $users->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')
    @include('backend.common.changestatus', ['url' => 'change-user-status'])

@endsection
