@extends('backend.layouts.app')
@section('title', 'Profile Edit')
@section('admin-dashboard-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">User Edit</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ route('user.index') }}">User</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="user-form" action="{{ route('profile.update', \Crypt::encrypt($user->id)) }}" method="POST"
                    enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="_method" value="PUT">
                    <input type="hidden" name="role" value="{{ auth()->user()->roles->first()->id }}">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">{{ __('User Name') }} <span
                                                        class="text-danger">*</span></label>
                                                <input required type="text"
                                                    class="form-control  @error('name') is-invalid @enderror" name="name"
                                                    placeholder="User Name" value="{{ $user->name }}">
                                                @error('name')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">{{ __('Email') }} <span
                                                        class="text-danger">*</span></label>
                                                <input required type="email"
                                                    class="form-control  @error('email') is-invalid @enderror"
                                                    name="email" placeholder="User Email" value="{{ $user->email }}">
                                                @error('email')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="role" class="form-label">
                                                    {{ __('Role') }}<span class="text-danger">*</span>
                                                </label>
                                                <input readonly type="text" class="form-control"
                                                    value="{{ auth()->user()->roles->first()->name }}">
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <input type="hidden" name="old_password" value="{{ $user->password }}">
                                                <label for="password" class="form-label">{{ __('Password') }} </label>
                                                <div class="input-group mb-3">


                                                    <input type="password"
                                                        class="form-control input-password @error('password') is-invalid @enderror"
                                                        name="password" placeholder="User Password"
                                                        value="{{ old('password') }}">
                                                    <button class="toggle-password" type="button"
                                                        aria-label="Show password as plain text. Warning: this will display your password on the screen.">
                                                    </button>
                                                </div>

                                                <input type="hidden" name="old_password" value="{{ $user->password }}">
                                                @error('password')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{ __('Save') }}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3 text-center">
                                                <input type="hidden" id="oldFilePath" value="{{ Storage::disk('public')->url($user->profile_image) }}" />
                                                @if (isset($user->profile_image) && Storage::disk('public')->exists($user->profile_image))
                                                    <img id="frame" height="250px"
                                                        src="{{ asset('storage/' . $user->profile_image) }}"
                                                        class="" />
                                                @else
                                                    <img id="frame" height="250px" class=""
                                                        src="{{ asset('backend/images/no-image.png') }}" alt="">
                                                @endif
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="Image" class="form-label">Profile Image</label>
                                                <input class="form-control @error('file') is-invalid @enderror"
                                                    type="file" name="profile_image" id="formFile"
                                                    onchange="preview()">
                                                @error('profile_image')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                                <a onclick="clearImage()" class="btn btn-primary mt-3">Clear Image</a>

                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->


                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('common.showpassword')
    <script>
        function preview() {
            frame.src = URL.createObjectURL(event.target.files[0]);
        }

        function clearImage() {
            document.getElementById('formFile').value = null;
            const oldFilePath = document.getElementById('oldFilePath').value;
            if (oldFilePath) {
                frame.src = oldFilePath; // Display the old image if it exists
            } else {
                frame.src = ""; // Otherwise, clear the frame
            }
        }
    </script>
@endsection
