@extends('backend.layouts.app')
@section('title', 'User Detail')
@section('user-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if (session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if (session()->has('fail'))
                    <div class="alert alert-danger">
                        {{ session()->get('fail') }}
                    </div>
                @endif
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('User Detail') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ route('user.index') }}">{{ __('User') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{ __('Detail') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="container py-5">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="card mb-4">
                                    <div class="card-body text-center">
                                        @if (isset($user->profile_image) && Storage::disk('public')->exists($user->profile_image))
                                            <img src="{{ asset('storage/' . $user->profile_image) }}" alt="avatar"
                                                class="rounded-circle img-fluid" style="width: 150px;">
                                        @else
                                            <img src="{{ asset('backend/images/admin_avatar.png') }}" alt="avatar"
                                                class="rounded-circle img-fluid" style="width: 150px;">
                                        @endif
                                        <h5 class="my-3">{{ $user->name }}</h5>
                                        <p class="text-muted mb-1">{{ __('Role') }}: {{ $user->roleName() }}</p>

                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">{{ __('Full Name') }}</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{ $user->name }}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">{{ __('Email') }}</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{ $user->email }}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">{{ __('Created By') }}</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{ $user->CreatedBy->name }}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">{{ __('Updated By') }}</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{ $user->UpdatedBy->name ?? '' }}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">{{ __('Last Login At') }}</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">
                                                    {{ $user->login_at ? date($date_format->value, strtotime($user->login_at)) : '' }}
                                                </p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                    </div>
                                </div>
                            </div>
                            <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div>
                    <!-- end container -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.changestatus', ['url' => 'change-user-status'])

@endsection
