@extends('backend.layouts.app')
@section('title','Video Create')
@section('video-active','active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                {{--  @include('backend.common.message')  --}}

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Video Create")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('video.index')}}">Video</a></li>
                                    <li class="breadcrumb-item active">{{__("Create")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <form class="video-form" action="{{ route('video.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 col-xl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title" class="form-label">{{__("Title(English)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title') is-invalid @enderror" name="title"
                                                    placeholder="Title(English)" value="{{old('title')}}" >
                                                @error('title')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="title_mm" class="form-label">{{__("Title(Myanmar)")}} <span class="text-danger">*</span></label>
                                                <input required type="text" class="form-control  @error('title_mm') is-invalid @enderror" name="title_mm"
                                                    placeholder="Title(Myanmar)" value="{{old('title_mm')}}" >
                                                @error('title_mm')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="link" class="form-label">{{__("Youtube Video Link")}}<span class="text-danger">*</span></label>
                                                <input type="text" required class="form-control @error('link') is-invalid @enderror"  name="link" value="{{old('link')}}" >
                                                @error('link')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_keyword" class="form-label">{{__("Meta Keyword")}}</label>
                                                <input type="text" class="form-control @error('meta_keyword') is-invalid @enderror" name="meta_keyword"  value="{{old('meta_keyword')}}"  >
                                                @error('meta_keyword')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                        <!-- end col -->

                                        {{--  <div class="col-md-12">
                                            <div class="mb-3">
                                                <label for="meta_description" class="form-label">{{__("Meta Description")}}</label>
                                                <textarea class="form-control @error('meta_description') is-invalid @enderror"  name="meta_description" >{{old('meta_description')}}</textarea>
                                                @error('meta_description')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>  --}}
                                        <!-- end col -->

                                    </div>
                                    <!-- end row -->
                                    <div>
                                        <button class="btn btn-primary" type="submit">{{__("Save")}}</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </form>
                <!-- end form -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
