@extends('backend.layouts.app')
@section('title', 'Video List')
@section('video-active', 'active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                @include('backend.common.message')

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{ __('Video List') }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Video') }}</a></li>
                                    <li class="breadcrumb-item active">{{ __('List') }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <form action="" method="get" class="form myform">
                                            @csrf
                                            <input type="hidden" name="order_by" value="videos.id">
                                            <input type="hidden" name="direction" value="desc">
                                            <div class="row">
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="mb-4">
                                                        <input class="form-control " type="text" name="search"
                                                            placeholder="Search"
                                                            value="{{ $input['search'] ?? old('search') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-xs-3">
                                                    <div class="form-group">
                                                        <div class="text-left mb-4">
                                                            <button type="submit" name="submit"
                                                                class="btn btn-info btn-fill btn-wd form-submit"><span
                                                                    class="fa fa-search"></span>
                                                                {{ __('Search') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end col -->
                                    @if (auth()->user()->hasPermissionTo('video_create'))
                                        <div class="col-md-4">
                                            <div class="float-md-end">
                                                <form action="{{ route('video.create') }}" class="form" method="get">

                                                    <div class="mb-4">
                                                        <button type="submit"
                                                            class="btn btn-success waves-effect waves-light"> <i
                                                                class="mdi mdi-plus me-2"></i>{{ __('Add Video') }}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    @endif
                                </div>
                                <!-- end row -->
                                <!-- start of table content -->
                                <div class="table table-responsive">
                                    <table class="table mb-0" id="myTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('No') }}</th>
                                                <th class="order-by order-by-arrow videos-title">
                                                    <span class='videos.title'>
                                                        @if (session()->get('locale') == 'en')
                                                            {{ __('Title(English)') }}
                                                        @else
                                                            {{ __('Title(Myanmar)') }}
                                                        @endif
                                                    </span>
                                                </th>
                                                <th>{{ __('Created By') }}</th>
                                                <th>{{ __('Updated By') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($videos as $key => $video)
                                                <tr>
                                                    <th scope="row">{{ $videos->firstItem() + $key }}</th>
                                                    {{-- <td>
                                                    @if (isset($video->profile_image) && Storage::disk('public')->exists($video->profile_image))
                                                        <img class="avatar-xs rounded-circle" src="{{ asset('storage/'.$video->profile_image) }}" alt="">
                                                    @else
                                                        <img class="avatar-xs rounded-circle" src="{{ asset('backend/images/admin_avatar.png') }}" alt="">
                                                    @endif
                                                    </td> --}}
                                                    <td>
                                                        @if (session()->get('locale') == 'en')
                                                            {{ $video->title }}
                                                        @else
                                                            {{ $video->title_mm }}
                                                        @endif
                                                    </td>

                                                    <td>{{ $video->CreatedBy->name }}</td>
                                                    <td>{{ $video->UpdatedBy->name ?? '' }}</td>
                                                    <td>
                                                        @if (auth()->user()->hasPermissionTo('video_list'))
                                                            <a href="{{ route('video.show', \Crypt::encrypt($video->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="View"><i class="mdi mdi-information"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('video_edit'))
                                                            <a href="{{ route('video.edit', \Crypt::encrypt($video->id)) }}"
                                                                class="me-3 text-primary" data-bs-placement="top"
                                                                title="Edit"><i
                                                                    class="mdi mdi-pencil font-size-18"></i></a>
                                                        @endif
                                                        @if (auth()->user()->hasPermissionTo('video_delete'))
                                                            <a href="javascript:void(0);" class="text-danger delete-record"
                                                                data-bs-placement="top" title="Delete"
                                                                data-id="{{ \Crypt::encrypt($video->id) }}"
                                                                data-action="{{ route('video.destroy', 1) }}"><i
                                                                    class="mdi mdi-trash-can font-size-18"></i></a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>
                                <!-- end of table content -->
                                <!--paginate-->
                                <div class="d-flex justify-content-end">
                                    <div>
                                        {!! $videos->appends($input)->links() !!}
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    @include('backend.common.orderbycolumn')

@endsection
