@extends('backend.layouts.app')
@section('title','Video Detail')
@section('video-active','mm-active active')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('fail'))
                    <div class="alert alert-danger">
                        {{ session()->get('fail') }}
                    </div>
                @endif
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">{{__("Video Detail")}}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{route('video.index')}}">{{__("Video")}}</a></li>
                                    <li class="breadcrumb-item active">{{__("Detail")}}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="container py-5" >
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Title(English)")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">
                                                        {{$video->title}}
                                                </p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Title(Myanmar)")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$video->title_mm}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Youtube Video Link")}}</strong>
                                            </div>
                                            <div class="col p-2">
                                                <iframe class="youtube-video" src="{{$video->link}}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{$video->link}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Meta Keyword")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$video->meta_keyword}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        {{--  <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Meta Description")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0">{{$video->meta_description}}</p>
                                            </div>
                                        </div>  --}}
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Created By")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{$video->CreatedBy->name}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <strong class="mb-0">{{__("Updated By")}}</strong>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0 ">{{$video->UpdatedBy->name??''}}</p>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                    </div>
                                    <!-- end card-body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div>
                    <!-- end container -->
                </div>
                <!-- end row -->
            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
