@extends('frontend.layouts.app')
@if(session()->get('locale') == 'mm')
    @section('title','CPU - အသိပညာပေး')
@else
    @section('title','CPU - Awareness')
@endif
@section('meta_keywords','အသိပညာပေး ,'.$metaKeywords)
@section('meta_description','အသိပညာပေး')
@section('content')
    <main>
        <!-- news -->
        <article>
            <div class="container-fluid ">
                <div class="container pt-3 pb-3 pagination-videos">
                    <div class="col d-flex justify-content-between align-items-center p-2">
                        <h4 class="text-md-start text-center p-2 m-0">
                            <i class="fa-brands fa-youtube"></i> Latest Videos
                        </h4>
                    </div>
                    <div class="col p-2">
                        <a href="#">
                            <marquee class="text-blue">
                                {{ $running_text->value }}
                            </marquee>
                        </a>
                    </div>
                    <div class="row">
                        @foreach($videos as $video)
                        <div class="col-xl-3 col-lg-6 col-md-6" >
                            <div class="card border-0">
                                <div class="card-body p-2">
                                    <div class="col p-2">
                                        <iframe class="youtube-video" src="{{$video->link}}"
                                            title="YouTube video player" frameborder="0"
                                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                            allowfullscreen></iframe>
                                    </div>
                                    <div class="col">
                                        <p class="fs-7 p-2 m-0">
                                            @if(session()->get('locale') == 'mm')
                                                {{__('Date')}} - {{convert_full_month(date($date_format->value,strtotime($video->created_at)))}}
                                            @else
                                                {{__('Date')}} - {{date($date_format->value,strtotime($video->created_at))}}
                                            @endif
                                        </p>
                                        <h5 class="fs-6 lh-lg p-2 m-0">
                                            @if(session()->get('locale') == 'mm')
                                                {{$video->title_mm}}
                                            @else
                                                {{$video->title}}
                                            @endif
                                        </h5>
                                        {{--  <div class="col text-center p-2">
                                            <a href="./posts-detail.html" class="btn btn-outline-cpu-blue btn-animate">
                                                {{ __('Read More') }}
                                            </a>
                                        </div>  --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="col p-2" id="pagination-videos">
                        {{ $videos->withQueryString()->links('frontend.pagination', ['paginationLink' => 'pagination-videos']) }}
                    </div>
                </div>
                <div class="container pt-3 pb-3 pagination-posts">
                    <div class="col d-flex justify-content-between align-items-center p-2">
                        <h4 class="text-md-start text-center p-2 m-0">
                            <i class="fa-solid fa-newspaper"></i> {{__("Latest Posts")}}
                        </h4>
                    </div>
                    <div class="col p-2">
                        <a href="#">
                            <marquee class="text-blue">
                                {{ $running_text->value }}
                            </marquee>
                        </a>
                    </div>
                    <div class="row">
                        @foreach($posts as $post)
                        <div class="col-xl-3 col-lg-6 col-md-6" >
                            <div class="card border-0">
                                <div class="card-body p-2">
                                    <div class="col p-2">
                                        <img src="{{asset('storage/'.$post->feature_image)}}" alt="{{ session()->get('locale') == 'mm'? $post->title_mm : $post->title }}"
                                            class="img-fluid rounded">
                                    </div>
                                    <div class="col">
                                        <p class="fs-7 p-2 m-0">
                                            @if(session()->get('locale') == 'mm')
                                                {{__('Date')}} - {{convert_full_month(date($date_format->value,strtotime($post->created_at)))}}
                                            @else
                                                {{__('Date')}} - {{date($date_format->value,strtotime($post->created_at))}}
                                            @endif
                                        </p>
                                        <h5 class="fs-6 lh-lg p-2 m-0" style="height:75px;overflow:hidden;">
                                            @if(session()->get('locale') == 'mm')
                                                {{$post->title_mm}}
                                            @else
                                                {{$post->title}}
                                            @endif
                                        </h5>
                                        <div class="col text-center p-2" >
                                            <a href="{{route('new-detail',$post->slug)}}" class="btn btn-outline-cpu-blue btn-animate">
                                                {{ __('Read More') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="col p-2" id="pagination-posts">
                        {{ $posts->withQueryString()->links('frontend.pagination', ['paginationLink' => 'pagination-posts']) }}
                    </div>
                </div>
                <div class="container pt-3 pb-3 pagination-books">
                    <div class="col d-flex justify-content-between align-items-center p-2">
                        <h4 class="text-md-start text-center p-2 m-0">
                            <i class="fa-solid fa-book"></i> {{__("Books")}}
                        </h4>
                    </div>
                    <div class="col p-2">
                        <a href="#">
                            <marquee class="text-blue">
                                {{ $running_text->value }}
                            </marquee>
                        </a>
                    </div>
                    <div class="row">
                        @foreach($books as $book)
                        <div id="content" class="col-xl-3 col-lg-6 col-md-6" >
                            <div class="card border-0">
                                <div class="card-body p-2">
                                    <div class="col">
                                        <p class="fs-7 p-2 m-0">
                                            @if(session()->get('locale') == 'mm')
                                                {{__('Date')}} - {{convert_full_month(date($date_format->value,strtotime($book->created_at)))}}
                                            @else
                                                {{__('Date')}} - {{date($date_format->value,strtotime($book->created_at))}}
                                            @endif
                                        </p>
                                        <h5 class="fs-6 lh-lg p-2 m-0" style="height:75px;overflow:hidden;">
                                            @if(session()->get('locale') == 'mm')
                                                {{$book->title_mm}}
                                            @else
                                                {{$book->title}}
                                            @endif
                                        </h5>
                                        <div class="col text-center p-2">
                                            <a href="{{asset('storage/'.$book->file_url)}}" class="btn btn-outline-cpu-blue btn-animate" download="{{$book->title}}" >
                                                <i class="fa fa-download"></i> {{ __('Download') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="col p-2" id="pagination-books">
                        {{ $books->withQueryString()->links('frontend.pagination', ['paginationLink' => 'pagination-books']) }}
                    </div>
                </div>
            </div>
        </article>
    </main>
@endsection
@section('custom_js')
<script src="{{asset('frontend/assets/js/jquery.min.js')}}"></script>
<script>
    $('.page-link').click(function(e) {
        e.preventDefault(); // Prevent the default link behavior

        var paginationId = $(this).data('target'); // Get the pagination ID from the 'data-target' attribute
        var position = $('.' + paginationId).offset().top; // Get the position relative to the document top

        // Store the position in session storage
        sessionStorage.setItem('scrollPosition', position);

        // Trigger the page reload
        location.href = $(this).attr('href');
      });

      // Check if there is a stored position in session storage
      var storedPosition = sessionStorage.getItem('scrollPosition');
      if (storedPosition) {
        // Scroll to the stored position
        $('html, body').animate({ scrollTop: storedPosition }, 'slow');

        // Clear the stored position from session storage
        sessionStorage.removeItem('scrollPosition');
      }
</script>
@endsection
