@extends('frontend.layouts.app')
@section('title','CPU - Contact Us')
@section('content')
<main>
    <div class="container-fluid">
      <div class="container pt-3 pb-3">
        <div class="row">
          <div class="col-xl-4 col-lg-4 col-md-4">
            <div class="col text-center p-2">
                @if($data['logo1']->logo_url != null && Storage::disk('public')->has($data['logo1']->logo_url))
                    <img src="{{ asset('storage/'.$data['logo1']->logo_url) }}" alt="contact-icon" class="contact-icon">
                @else
                    <img src="{{asset(ContactUs::PHONE_IMAGE)}}" alt="contact-icon" class="contact-icon">
                @endif
            </div>
            <div class="col text-center">
              <h4 class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo1']->title_mm}}
                @else
                    {{$data['logo1']->title}}
                @endif
              </h4>
              <p class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo1']->desc_mm}}
                @else
                    {{$data['logo1']->desc}}
                @endif
              </p>
            </div>
          </div>
          <div class="col-xl-4 col-lg-4 col-md-4">
            <div class="col text-center p-2">
                @if($data['logo2']->logo_url != null && Storage::disk('public')->has($data['logo2']->logo_url))
                    <img src="{{ asset('storage/'.$data['logo2']->logo_url) }}" alt="contact-icon" class="contact-icon">
                @else
                    <img src="{{asset(ContactUs::EMAIL_IMAGE)}}" alt="contact-icon" class="contact-icon">
                @endif
            </div>
            <div class="col text-center">
              <h4 class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo2']->title_mm}}
                @else
                    {{$data['logo2']->title}}
                @endif
              </h4>
              <p class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo2']->desc_mm}}
                @else
                    {{$data['logo2']->desc}}
                @endif
              </p>
            </div>
          </div>
          <div class="col-xl-4 col-lg-4 col-md-4">
            <div class="col text-center p-2">
                @if($data['logo3']->logo_url != null && Storage::disk('public')->has($data['logo3']->logo_url))
                    <img src="{{ asset('storage/'.$data['logo3']->logo_url) }}" alt="contact-icon" class="contact-icon">
                @else
                    <img src="{{asset(ContactUs::ADDRESS_IMAGE)}}" alt="contact-icon" class="contact-icon">
                @endif
            </div>
            <div class="col text-center">
              <h4 class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo3']->title_mm}}
                @else
                    {{$data['logo3']->title}}
                @endif
              </h4>
              <p class="p-2 m-0">
                @if(session()->get('locale') == 'mm')
                    {{$data['logo3']->desc_mm}}
                @else
                    {{$data['logo3']->desc}}
                @endif
              </p>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col p-2">
            <iframe src="{{$data['map']->map_frame}}" width="100%" height="450" style="border:0; border-radius: 10px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>
        </div>
      </div>
    </div>
</main>
@endsection
