@extends('frontend.layouts.app')
@if(session()->get('locale') == 'mm')
    @section('title',$home->title_mm)
@else
    @section('title',$home->title)
@endif
@section('meta_keywords',$home->meta_keyword)
@section('meta_description',$home->meta_description)
@section('content')
    <main>
        <!-- banner -->
        @if (isset($sliders))
            <div id="carouselExampleCaptions" class="carousel slide">
                <div class="carousel-indicators">
                    @foreach ($sliders as $key => $slider)
                        @if ($loop->first)
                            <button type="button" data-bs-target="#carouselExampleCaptions"
                                data-bs-slide-to="{{ $key }}" class="active" aria-current="true"
                                aria-label="Slide {{ $key }}"></button>
                        @else
                            <button type="button" data-bs-target="#carouselExampleCaptions"
                                data-bs-slide-to="{{ $key }}" class="" aria-current="true"
                                aria-label="Slide {{ $key }}"></button>
                        @endif
                    @endforeach
                </div>
                <div class="carousel-inner">
                    @foreach ($sliders as $key => $slider)
                        @if ($loop->first)
                            <div class="carousel-item active">
                                <img src="{{ asset('storage/' . $slider->feature_image) }}" class="d-block w-100 banner-image"
                                    alt="{{ $slider->title }}">
                                <div class="carousel-caption d-none d-md-block">
                                    <p>
                                        {{ $slider->title }}
                                    </p>
                                </div>
                            </div>
                        @else
                            <div class="carousel-item ">
                                <img src="{{ asset('storage/' . $slider->feature_image) }}" class="d-block w-100 banner-image"
                                    alt="{{ $slider->title }}">
                                <div class="carousel-caption d-none d-md-block">
                                    <p>
                                        {{ $slider->title }}
                                    </p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        @else
            <div id="carouselExampleCaptions" class="carousel slide">
                <div class="carousel-indicators">
                    <button type="button" data-bs-target="#carouselExampleCaptions" data-bs-slide-to="0" class="active"
                        aria-current="true" aria-label="Slide 1"></button>
                    <button type="button" data-bs-target="#carouselExampleCaptions" data-bs-slide-to="1"
                        aria-label="Slide 2"></button>
                    <button type="button" data-bs-target="#carouselExampleCaptions" data-bs-slide-to="2"
                        aria-label="Slide 3"></button>
                </div>
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <img src="{{ asset('frontend/assets/image/home/banner/banner01.png') }}"
                            class="d-block w-100 banner-image" alt="Banner Image 01">
                        <div class="carousel-caption d-none d-md-block">
                            <p>
                                ကချင်ပြည်နယ်အစိုးရအဖွဲ့နှင့်အဂတိလိုက်စားမှုတိုက်ဖျက်ရေးကော်မရှင်တို့ ...
                            </p>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img src="{{ asset('frontend/assets/image/home/banner/banner02.png') }}"
                            class="d-block w-100 banner-image" alt="Banner Image 02">
                        <div class="carousel-caption d-none d-md-block">
                            <p>
                                ကချင်ပြည်နယ်အစိုးရအဖွဲ့နှင့်အဂတိလိုက်စားမှုတိုက်ဖျက်ရေးကော်မရှင်တို့ ...
                            </p>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img src="{{ asset('frontend/assets/image/home/banner/banner03.png') }}"
                            class="d-block w-100 banner-image" alt="Banner Image 03">
                        <div class="carousel-caption d-none d-md-block">
                            <p>
                                ကချင်ပြည်နယ်အစိုးရအဖွဲ့နှင့်အဂတိလိုက်စားမှုတိုက်ဖျက်ရေးကော်မရှင်တို့ ...
                            </p>
                        </div>
                    </div>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        @endif
        <!-- info -->
        <div class="container-fluid">
            <div class="container pt-3 pb-3">
                <div class="col p-2">
                    <h3 class="site-title text-blue text-center p-2 m-0">
                        {{ session()->get('locale') == 'en' ? $home->title : $home->title_mm }}
                    </h3>
                    <p class="p-2 m-0">
                        @if (session()->get('locale') == 'en')
                            {!! $home->body !!}
                        @else
                            {!! $home->body_mm !!}
                        @endif
                    </p>
                    <div class="col text-center p-2">
                        <a class="btn btn-outline-cpu-blue btn-animate" href="{{ $home->linkTo->link }}">
                            {{ __('Read More') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- latest news -->
        <article>
            <div class="container-fluid">
                <div class="container pt-3 pb-3">
                    <div class="col d-flex justify-content-between align-items-center p-2">
                        <h4 class="text-md-start text-center p-2 m-0">
                            <i class="fa-solid fa-newspaper"></i> Latest News
                        </h4>
                        <span class="p-2">
                            <a href="{{ route('news') }}" class="btn btn-outline-cpu-blue">
                                {{ __('View All') }}
                            </a>
                        </span>
                    </div>
                    <div class="col p-2">
                        <a href="#">
                            <marquee class="text-blue">
                                {{ $running_text->value }}
                            </marquee>
                        </a>
                    </div>
                    <div class="row">
                        @foreach($latestNews as $key=>$lnew)
                        <div class="col-xl-3 col-lg-6 col-md-6">
                            <div class="card border-0">
                                <div class="card-body p-2">
                                    <div class="col p-2">
                                        <img src="{{asset('storage/'.$lnew->feature_image)}}" alt="{{ session()->get('locale') == 'mm'? $lnew->title_mm : $lnew->title }}"
                                            class="img-fluid rounded">
                                    </div>
                                    <div class="col">
                                        <p class="fs-7 p-2 m-0">
                                            @if(session()->get('locale') == 'mm')
                                                {{__('Date')}} - {{convert_full_month(date($date_format->value,strtotime($lnew->created_at)))}}
                                            @else
                                                {{__('Date')}} - {{date($date_format->value,strtotime($lnew->created_at))}}
                                            @endif
                                        </p>
                                        <h5 class="fs-6 lh-lg p-2 m-0" style="height:75px;overflow:hidden;">
                                            @if(session()->get('locale') == 'mm')
                                                {{$lnew->title_mm}}
                                            @else
                                                {{$lnew->title}}
                                            @endif
                                        </h5>
                                        <div class="col text-center p-2">
                                            <a class="btn btn-outline-cpu-blue btn-animate" href="{{route('new-detail',$lnew->slug)}}" >
                                                {{ __('Read More') }}
                                            </a>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end col -->
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        @endforeach
                    </div>
                    <!-- end row -->
                </div>
                <!-- end container -->
            </div>
        </article>
    </main>
@endsection
