<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title','CPU Kachin')</title>
    <!-- App favicon -->
    @if (isset($favicon->value) && Storage::disk('public')->exists($favicon->value))
        <link rel="icon" type="image/png" sizes="96x96" href="{{ asset('storage/' . $favicon->value) }}">
    @else
        <link rel="icon" type="image/png" sizes="96x96" href="{{ asset('backend/images/favicon.png') }}">
    @endif
    <meta name="keywords" content="@yield('meta_keywords')">
    <meta name="description" content="@yield('meta_description')">
    <link rel="canonical" href="{{ url()->current() }}" />

    <link href="{{ asset('frontend/bootstrap/v5.3/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('frontend/fontawesome/css/all.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/style.css') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito&display=swap">

    <style>
        @font-face {
            font-family: 'Pyidaungsu';
            src: "{{ asset('backend/fonts/Pyidaungsu.ttf') }} format('truetype')";
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: Pyidaungsu !important;
        }
    </style>
    @yield('custom_css')
</head>

<body>
    @include('frontend.layouts.header')
    @yield('content')
    @include('frontend.layouts.footer')
    <script src="{{ asset('frontend/bootstrap/v5.3/js/bootstrap.bundle.min.js') }}" >
    </script>
    <script src="{{ asset('frontend/fontawesome/js/all.js') }}"></script>
    @yield('custom_js')
</body>

</html>
