<header>
    <!-- top bar -->
    <div class="container-fluid">
        <div class="container">
            <div class="row p-2">
                <div class="col-xl-4 col-lg-4 col-md-2 col-sm-4 col-2 m-auto">

                    @if (File::exists(public_path('storage/' . $left_logo->value)))
                        <img src="{{ asset('storage/' . $left_logo->value) }}" alt="Logo" class="header-logo">
                    @else
                        <img src="{{ asset(Setting::LEFT_LOGO) }}" alt="Logo"
                            class="header-logo">
                    @endif
                </div>
                <div class="col-xl-4 col-lg-4 col-md-8 col-sm-4 col-8 m-auto">
                    <h1 class="site-title text-blue text-center p-1 m-0">
                        @if (session()->get('locale') == 'en')
                            {{ $main_title_en->value }}
                        @else
                            {{ $main_title_mm->value }}
                        @endif
                    </h1>
                    <h4 class="site-description text-blue text-center p-1 m-0">
                        @if (session()->get('locale') == 'en')
                            {{ $sub_title_en->value }}
                        @else
                            {{ $sub_title_mm->value }}
                        @endif
                    </h4>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-2 col-sm-4 col-2 text-end m-auto">
                    {{--  @if (File::exists('storage/' . $right_logo->value))
                <img src="{{asset('storage/'.$right_logo->value)}}" alt="Logo" class="header-logo">
            @else
                <img src="{{asset(Setting::RIGHT_LOGO)}}" alt="Logo" class="header-logo">
            @endif  --}}
                </div>
            </div>
        </div>
    </div>
    <!-- navigation menus -->
    <div class="container-fluid bg-cpu-blue">
        <div class="container">
            <!-- desktop -->
            <div class="row d-lg-block d-none">
                <nav class="navbar navbar-expand-lg">
                    <div class="col pt-2 pb-2 ps-2 pe-0">
                        <button class="navbar-toggler m-auto border-0 shadow-none" type="button"
                            data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar"
                            aria-controls="offcanvasNavbar">
                            Menu <i class="fa-solid fa-bars"></i>
                        </button>
                        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar"
                            aria-labelledby="offcanvasNavbarLabel">
                            <div class="offcanvas-header bg-frd">
                                <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Corruption Prevention Unit</h5>
                                <button type="button" class="btn border-0 shadow-none" data-bs-dismiss="offcanvas"
                                    aria-label="Close">
                                    <i class="fa-solid fa-xmark"></i>
                                </button>
                            </div>
                            <div class="offcanvas-body bg-frd">
                                <ul class="navbar-nav desktop-menu mb-2 mb-lg-0">
                                    @foreach ($menu_items as $menuItem)
                                        @if (count($menuItem->child->where('status','active')) > 0)
                                            <li class="nav-item dropdown">
                                                <a class="nav-link dropdown-toggle" href="#" role="button"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                    @if (session()->get('locale') == 'mm')
                                                        {{ $menuItem->label_mm }}
                                                    @else
                                                        {{ $menuItem->label }}
                                                    @endif
                                                </a>
                                                <ul class="dropdown-menu main-menus">
                                                    @foreach ($menuItem->child->where('status','active') as $submenus)
                                                        @include('frontend.layouts.submenu', [
                                                            'submenus' => $submenus,
                                                        ])
                                                    @endforeach
                                                </ul>
                                            </li>
                                        @else
                                            <li class="nav-item">
                                                <a class="nav-link" href="{{ $menuItem->link }}">
                                                    @if (session()->get('locale') == 'mm')
                                                        {{ $menuItem->label_mm }}
                                                    @else
                                                        {{ $menuItem->label }}
                                                    @endif
                                                </a>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                                <div class="col text-end d-none d-lg-block m-auto">
                                    @if (session()->get('locale') == 'mm')
                                        <a href="{{ route('lang', 'en') }}" class="btn text-light">
                                            <img src="{{ asset('frontend/assets/image/language/english.png') }}"
                                                alt="english" class="ln-flag"> EN
                                        </a>
                                    @else
                                        <a href="{{ route('lang', 'mm') }}" class="btn text-light">
                                            <img src="{{ asset('frontend/assets/image/language/myanmar.png') }}"
                                                alt="myanmar" class="ln-flag"> MM
                                        </a>
                                    @endif
                                    <button type="button" class="btn text-light" data-bs-toggle="collapse"
                                        href="#collapseExample">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                </nav>
            </div>
            <div class="collapse" id="collapseExample">
                <div class="card card-body bg-cpu-blue pt-0 pb-3 ps-0 pe-0 border-0">
                    <form id="searchForm" action="{{ route('search') }}" method="get">
                        @csrf
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" placeholder="Type Here...">
                            <button type="submit" class="btn btn-outline-light">
                                Search
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- end collapse -->
        </div>
        <!-- tablet, mobile -->
        <div class="col d-md-block d-lg-none pt-2 pb-2">
            <nav class="navbar navbar-expand-lg">
                <div class="col text-center">
                    <button class="navbar-toggler text-light m-auto border-0 shadow-none" type="button"
                        data-bs-toggle="offcanvas" data-bs-target="#menuOffcanvas" aria-controls="offcanvasNavbar">
                        Menu <i class="fa-solid fa-bars"></i>
                    </button>
                    <div class="offcanvas offcanvas-end" tabindex="-1" id="menuOffcanvas"
                        aria-labelledby="offcanvasNavbarLabel">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Corruption Prevention Unit</h5>
                            <button type="button" class="btn border-0 shadow-none" data-bs-dismiss="offcanvas"
                                aria-label="Close">
                                <i class="fa-solid fa-circle-xmark fa-lg"></i>
                            </button>
                        </div>
                        <div class="offcanvas-body text-start">
                            <div class="col p-2">
                                <a href="{{ route('home') }}" class="text-dark text-decoration-none text-wrap p-2">
                                    Home
                                </a>
                            </div>
                            <div class="col p-2">
                                <a href="{{ route('news') }}" class="text-dark text-decoration-none text-wrap p-2">
                                    News
                                </a>
                            </div>
                            <div class="col p-2">
                                <div class="d-flex justify-content-between">
                                    <a href="#" class="text-dark text-decoration-none text-wrap p-2">
                                        About Us
                                    </a>
                                    <span class="btn p-1 border-0" data-bs-toggle="collapse" href="#submenu01">
                                        <i class="fa-solid fa-chevron-down"></i>
                                    </span>
                                </div>
                                <div class="collapse" id="submenu01">
                                    <div class="card card-body border-0 p-2">
                                        <a href="{{ route('company') }}"
                                            class="text-dark text-decoration-none text-wrap border-left-3 p-2">
                                            အဖွဲ့အစည်း
                                        </a>
                                        <a href="{{ route('contact-us') }}"
                                            class="text-dark text-decoration-none text-wrap border-left-3 p-2">
                                            Contact Us
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col p-2">
                                <a href="{{ route('awareness') }}"
                                    class="text-dark text-decoration-none text-wrap p-2">
                                    Awareness
                                </a>
                            </div>
                            <div class="col p-2">
                                <a href="{{ route('suggestion') }}"
                                    class="text-dark text-decoration-none text-wrap p-2">
                                    Suggestion
                                </a>
                            </div>
                            <div class="col p-2">
                                @if (session()->get('locale') == 'mm')
                                    <a href="{{ route('lang', 'en') }}" class="btn">
                                        <img src="{{ asset('frontend/assets/image/language/english.png') }}"
                                            alt="english" class="ln-flag"> EN
                                    </a>
                                @else
                                    <a href="{{ route('lang', 'mm') }}" class="btn">
                                        <img src="{{ asset('frontend/assets/image/language/myanmar.png') }}"
                                            alt="myanmar" class="ln-flag"> MM
                                    </a>
                                @endif

                                {{--  <a href="#" class="btn">
                                    <img src="{{ asset('frontend/assets/image/language/myanmar.png') }}"
                                        alt="myanmar" class="ln-flag"> MM
                                </a>  --}}
                            </div>
                            <div class="col text-center d-lg-none d-xl-none p-2">
                                <form id="searchForm">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Type Here...">
                                        <button type="submit" class="btn btn-outline-cpu-blue">
                                            Search
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
            </nav>
        </div>
    </div>
    </div>
    </div>
</header>
