@extends('frontend.layouts.app')
@if(session()->get('locale') == 'mm')
    @section('title',$new->title_mm)
@else
    @section('title',$new->title)
@endif
@section('meta_keywords',$new->meta_keyword)
@section('meta_description',$new->meta_description)

@section('content')
<main>
    <div class="container-fluid">
      <div class="container pt-3 pb-3">
        <div class="col p-2">
          <a href="{{ url()->previous() }}" class="btn">
            <i class="fa-regular fa-circle-left"></i> {{__("Back")}}
          </a>
        </div>
        <div class="col p-2">
          <h5 class="text-center p-2 m-0">
            @if(session()->get('locale') == 'mm')
                {{$new->title_mm}}
            @else
                {{$new->title}}
            @endif
          </h5>
          <div class="col p-2 text-center">
            <img src="{{ asset('storage/'.$new->feature_image) }}" alt="company-image" class="img-fluid rounded">
          </div>
          <p class="p-2 m-0">
            @if(session()->get('locale') == 'mm')
                {!! $new->body_mm !!}
            @else
                {!! $new->body !!}
            @endif
          </p>
        </div>
      </div>
    </div>
</main>
@endsection
