@if ($paginator->hasPages())
<nav aria-label="Page navigation example">
    <ul class="pagination justify-content-center cpu-pagination m-0">
        @if($paginator->onFirstPage())
            <li class="page-item"><a class="page-link" href="javascript:;">Previous</a></li>
        @else
            <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}" data-target="{{$paginationLink}}" data-position="0">Previous</a></li>
        @endif
        @foreach ($elements as $element)
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="page-item"><a class="page-link active">{{ $page }}</a></li>
                    @else
                        <li class="page-item"><a class="page-link" href="{{ $url }}" data-target="{{$paginationLink}}" data-position="0">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach
        @if ($paginator->hasMorePages())
            <li class="page-item"><a class="page-link" href="{{ $paginator->nextPageUrl() }}" data-target="{{$paginationLink}}" data-position="0">Next</a></li>
        @else
            <li class="page-item"><a class="page-link" href="javascript:;">Next</a></li>
        @endif
    </ul>
</nav>
@endif
