@extends('frontend.layouts.app')
@section('title', 'CPU - News')
@section('content')
    <main>
        {{--  {{dd(session()->get('locale'))}}  --}}
        <!-- news -->
        <article>
            <div class="container-fluid">
                <div class="container pt-3 pb-3">
                    <div class="col d-flex justify-content-between align-items-center p-2">
                        <h4 class="text-md-start text-center p-2 m-0">
                            <i class="fa-solid fa-magnifying-glass"></i> {{ __('Search') }}
                        </h4>
                    </div>
                    <div class="col p-2">
                        <a href="#">
                            <marquee class="text-blue">
                                {{ $running_text->value }}
                            </marquee>
                        </a>
                    </div>
                    <div class="row">
                        <div class="col-md-8"></div>
                        <div class="col-md-4">
                            <div class="form-group mb-3 me-3">
                                <form action="{{ route('search') }}" method="get">
                                    @csrf
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="search"
                                            placeholder="Type Here..." value="{{$search}}">
                                        <button type="submit" class="btn btn-primary">
                                            Search
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->
                    <div class="row">
                        @if (isset($posts) && count($posts) > 0)
                            @foreach ($posts as $new)
                                <div class="col-xl-3 col-lg-6 col-md-6">
                                    <div class="card border-0">
                                        <div class="card-body p-2">
                                            <div class="col p-2">
                                                <img src="{{ asset('storage/' . $new->feature_image) }}"
                                                    alt="{{ $new->title }}" class="img-fluid rounded">
                                            </div>
                                            <div class="col">
                                                <p class="fs-7 p-2 m-0">
                                                    @if (session()->get('locale') == 'mm')
                                                        {{ __('Date') }} -
                                                        {{ convert_full_month(date($date_format->value, strtotime($new->created_at))) }}
                                                    @else
                                                        {{ __('Date') }} -
                                                        {{ date($date_format->value, strtotime($new->created_at)) }}
                                                    @endif

                                                </p>
                                                <h5 class="fs-6 lh-lg p-2 m-0" style="height:75px;overflow:hidden;">
                                                    @if (session()->get('locale') == 'mm')
                                                        {{ $new->title_mm }}
                                                    @else
                                                        {{ $new->title }}
                                                    @endif

                                                </h5>
                                                <div class="col text-center p-2">
                                                    <a href="{{ route('new-detail', $new->slug) }}"
                                                        class="btn btn-outline-cpu-blue btn-animate">
                                                        {{ __('Read More') }}
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end card -->
                                </div>
                            @endforeach
                        @else
                        <div class="col-xl-3 col-lg-6 col-md-6" >
                            <p style="min-height: 30vh;color:red;">{{__("Contents not found!")}}</p>
                        </div>
                        @endif
                    </div>
                    <!-- end row -->
                    <div class="col p-2">
                        {{ $posts->withQueryString()->links('frontend.pagination',['paginationLink'=>'posts']) }}
                    </div>
                    <!-- end col -->
                </div>
            </div>
        </article>
    </main>
@endsection
