@extends('frontend.layouts.app')
@section('title', 'CPU - Suggestion')
@section('content')
    <main>
        <div class="container-fluid">
            <div class="container pt-3 pb-3">
                <div class="col-xl-4 col-lg-5 col-md-6 p-2 mx-auto">
                    <h5 class="p-2 m-0">
                        <i class="fa-solid fa-volume-low"></i> {{ __('Suggestion Form') }}
                    </h5>
                    <p class="lh-lg p-2 m-0">
                        အဖွဲ့ထံသို့ အကြံပြုလိုသည်များ၊ တောင်းဆိုလိုသည်များ စသည်တို့ကို ပေးပို့နိုင်ပါသည်။
                    </p>
                </div>
                <div class="row">
                    <div class="col-xl-4 col-lg-5 col-md-6 mx-auto">
                        <form action="{{ route('store-suggestion') }}" method="post">
                            @csrf
                            <div class="col p-2">
                                <p class="pb-2 m-0">
                                    {{ __('Name') }}
                                </p>
                                <input type="text" name="name"
                                    class="form-control @error('name') is-invalid @enderror">
                                @error('name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="col p-2">
                                <p class="pb-2 m-0">
                                    {{ __('NRC No') }}.
                                </p>
                                <input type="text" name="nrc"
                                    class="form-control @error('nrc') is-invalid @enderror">
                                @error('nrc')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="col p-2">
                                <p class="pb-2 m-0">
                                    {{ __('Phone No') }}.
                                </p>
                                <input type="text" name="phone"
                                    class="form-control @error('phone') is-invalid @enderror">
                                @error('phone')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="col p-2">
                                <p class="pb-2 m-0">
                                    {{ __('Address') }}
                                </p>
                                <textarea class="form-control @error('address') is-invalid @enderror" name="address" rows="3"></textarea>
                                @error('address')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="col p-2">
                                <p class="pb-2 m-0">
                                    {{ __('Message') }}
                                </p>
                                <textarea class="form-control @error('message') is-invalid @enderror" name="message" rows="3"></textarea>
                                @error('message')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            @if (session()->has('success'))
                                <div class="alert alert-success">
                                    {{ session()->get('success') }}
                                </div>
                            @endif

                            <div class="col text-center p-2">
                                <button type="submit" class="btn btn-outline-cpu-blue btn-animate">
                                    <i class="fa-solid fa-paper-plane"></i> Send
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
