{{-- @extends('backend.layouts.app')
@section('title','Logs Dashboard')
@section('log-dashboard-active','mm-active active') --}}
@extends('log-viewer::bootstrap-4._master')
@include('vendor.log-viewer.bootstrap-4.style')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                <div class="page-header mb-4">
                    <h1>@lang('Dashboard')</h1>
                </div>
                <div class="row">
                    <div class="col-md-6 col-lg-3">
                        <canvas id="stats-doughnut-chart" height="300" class="mb-3"></canvas>
                    </div>

                    <div class="col-md-6 col-lg-9">
                        <div class="row">
                            @foreach($percents as $level => $item)
                                <div class="col-sm-6 col-md-12 col-lg-4 mb-3">
                                    <div class="box level-{{ $level }} {{ $item['count'] === 0 ? 'empty' : '' }}">
                                        <div class="box-icon">
                                            {!! log_styler()->icon($level) !!}
                                        </div>

                                        <div class="box-content">
                                            <span class="box-text">{{ $item['name'] }}</span>
                                            <span class="box-number">
                                                {{ $item['count'] }} @lang('entries') - {!! $item['percent'] !!} %
                                            </span>
                                            <div class="progress" style="height: 3px;">
                                                <div class="progress-bar" style="width: {{ $item['percent'] }}%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->
@endsection
@section('custom_js')
    <script>
        $(function() {
            new Chart(document.getElementById("stats-doughnut-chart"), {
                type: 'doughnut',
                data: {!! $chartData !!},
                options: {
                    legend: {
                        position: 'bottom'
                    }
                }
            });
        });
    </script>
@endsection
