<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Backend\BookController;
use App\Http\Controllers\Backend\HomeController;
use App\Http\Controllers\Backend\MenuController;
use App\Http\Controllers\Backend\PostController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\VideoController;
use App\Http\Controllers\Backend\SettingController;
use App\Http\Controllers\Backend\ContactUsController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\SuggestionController;
use App\Http\Controllers\Backend\OrganizationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Auth::routes();

//if already auth and call /, redirect to home page
// Route::get('/admin_login', function () {
//     if (Auth::check()){
//         return redirect('admin/dashboard');
//     }else{
//         return view('backend.auth.login');
//     }
// });
//redirect to unauth for no permission user
Route::get('/unauth', function () {
    return view('backend.auth.unauth');
});
//forget password
Route::get('/forget-password',[LoginController::class,'showForgetPassword'])->name('forget-password-form');
Route::post('/forget-password',[LoginController::class,'forgetPassword'])->name('forget-password');
//reset password
Route::get('/reset-password',[LoginController::class,'showResetPassword'])->name('reset-password-form');
Route::post('/reset-password',[LoginController::class,'resetPassword'])->name('reset-password');

Route::get('/admin_login', [LoginController::class,'showLoginForm']);
Route::post('/admin_login', [LoginController::class,'login'])->name('admin-login');
Route::post('/logout', [LoginController::class,'logout'])->name('logout');

Route::group(['prefix' => 'admin', 'middleware' => ['auth'] ], function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin-dashboard');
    //get total suggestion
    Route::get('/dashboard/suggestions',[DashboardController::class,'getAllSuggestions'])->name('get-suggestions');
    //get suggestion by date
    Route::get('/dashboard/suggestions/today',[DashboardController::class,'getTodaySuggestion'])->name('get-today-suggestions');

    Route::resource('role',RoleController::class);
    Route::resource('user',UserController::class);

    //own profile
    Route::get('profile/{profile}/edit',[UserController::class,'profile'])->name('profile');
    Route::put('profile/{profile}',[UserController::class,'profileUpdate'])->name('profile.update');
    Route::post('/user-status',[UserController::class,'changeStatus'])->name('change-user-status');
    Route::resource('home',HomeController::class);
    Route::resource('organization',OrganizationController::class);
    Route::resource('contactus',ContactUsController::class);
    Route::post('/contactus-delete-image',[ContactUsController::class,'deleteImage'])->name('contactus-delete-image');
    Route::resource('suggestion',SuggestionController::class);
    Route::resource('book',BookController::class);
    Route::resource('video',VideoController::class);
    Route::resource('setting',SettingController::class);
    Route::post('/setting-delete-image',[SettingController::class,'deleteImage'])->name('setting-delete-image');
    Route::post('/book-status',[BookController::class,'changeStatus'])->name('change-book-status');
    //page
    // Route::resource('page',PageController::class);
    // Route::get('/get-menu-items',[PageController::class,'getItems'])->name('get-items');
    //new
    Route::resource('post',PostController::class);
    //delete one file
    Route::post('/post-file-destroy',[PostController::class,'fileDestroy'])->name('post-file-destroy');
    Route::post('/post-status',[PostController::class,'changeStatus'])->name('change-post-status');

    Route::post('/get-id',[PostController::class,'getDecryptId'])->name('get-decrypt-id');

    //Harimayco menu
    $path = rtrim(config('menu.route_path'));
    Route::get($path,[MenuController::class,'index'])->name('menu');
    Route::post($path.'/menu-drag',[MenuController::class,'menuDrag'])->name('menu-drag');
    Route::get($path.'/get-content',[MenuController::class,'getMenuItem'])->name('get-menuitem');
    Route::post($path.'/update-content',[MenuController::class,'updateMenuItem'])->name('update-menuitem');

    //log
    // Route::get('/logs', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@index')
    // ->name('log-viewer::index');
});
