<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TimeZoneController;
use App\Http\Controllers\Frontend\PageController;
use App\Http\Controllers\Frontend\PostController;
use App\Http\Controllers\LanguageController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//language switch
Route::get('language/{locale}', [LanguageController::class,'changeLocale'])->name('lang');
//website url
// Route::get('/',[HomeController::class,'frontTest']);

//save current timezone
Route::get('/timezone',[TimeZoneController::class,'saveTimeZone'])->name('save-timezone');

Route::get('/', [PageController::class,'home'])->name('home');
Route::get('/news', [PostController::class,'news'])->name('news');
Route::get('/new-detail/{slug}', [PostController::class,'newDetail'])->name('new-detail');
Route::get('/company', [PageController::class,'organization'])->name('company');
Route::get('/contact-us', [PageController::class,'contactUs'])->name('contact-us');
Route::get('/awareness', [PostController::class,'awareness'])->name('awareness');
Route::get('/suggestion', function () {
    return view('frontend.suggestion');
})->name('suggestion');
Route::post('/suggestion/store',[PageController::class,'storeSuggestion'])->name('store-suggestion');
Route::get('/search', [PostController::class,'search'])->name('search');

